export function isOauth2NotSupportedError(error: any): boolean {
    if (error && !Array.isArray(error.errors)) {
        return false;
    }
    return error.errors.some((e: any) => {
        const summary: string | undefined =
            e && typeof e.summary === 'string' ? e.summary : undefined;
        const details: string | undefined =
            e && typeof e.details === 'string' ? e.details : undefined;
        return (
            summary === 'OAuth2 is not supported for the remote application.' ||
            (details ? details.indexOf('OAuth2NotSupportedException') !== -1 : false)
        );
    });
}
