import PermissionsBitbucket from './bitbucket/PermissionsBitbucket';
import { PermissionsBasic } from './basic/PermissionsBasic';
import { PermissionsBamboo } from './bamboo/PermissionsBamboo';
import React, { useContext } from 'react';
import { PermissionsContext } from './PermissionsContext';
import { PermissionsRefapp } from './refapp/PermissionsRefapp';
import { NO_PERMISSIONS } from './PermissionsSelect.i18n';
import { Product } from './permissions';

export const PermissionsSelect = ({ scope, availableIncomingScopes }) => {
    const context = useContext(PermissionsContext);

    if (context.product === Product.BITBUCKET) {
        return <PermissionsBitbucket scopes={scope} />;
    } else if ([Product.JIRA, Product.CONFLUENCE].includes(context.product)) {
        return <PermissionsBasic scope={scope} availableIncomingScopes={availableIncomingScopes} />;
    } else if (context.product === Product.BAMBOO) {
        return <PermissionsBamboo scope={scope} />;
    } else if (context.product === Product.REFAPP) {
        return <PermissionsRefapp scope={scope} />;
    } else {
        return <p>{NO_PERMISSIONS}</p>;
    }
};
