import React from 'react';
import { BasicPermission } from '../permissions';
import { DropdownPermissions } from '../DropdownPermissions';

const basicSelectOptions = [
    { label: 'Read', value: 'READ' },
    { label: 'Write', value: 'WRITE' },
    { label: 'Admin', value: 'ADMIN' },
    { label: 'System admin', value: 'SYSTEM_ADMIN' },
    { label: 'JSM Knowledge Base', value: 'JSM_KB' },
];

function getSelectOptions(availableIncomingScope) {
    return basicSelectOptions.filter((option) => availableIncomingScope.includes(option.value));
}

function basicScopeToSelectOption(scope) {
    switch (scope) {
        case 'READ':
            return basicSelectOptions[0];
        case 'WRITE':
            return basicSelectOptions[1];
        case 'ADMIN':
            return basicSelectOptions[2];
        case 'SYSTEM_ADMIN':
            return basicSelectOptions[3];
        case 'JSM_KB':
            return basicSelectOptions[4];
        default:
            return basicSelectOptions[0];
    }
}

export function basicPermissionRank(permission) {
    switch (permission) {
        case BasicPermission.READ:
            return 0;
        case BasicPermission.WRITE:
            return 1;
        case BasicPermission.ADMIN:
            return 2;
        case BasicPermission.SYSTEM_ADMIN:
            return 3;
        case BasicPermission.JSM_KB:
            return 4;
    }
}

export function handleInheritedScopesForConfluenceAndJira(scopes) {
    if (scopes.includes(BasicPermission.WRITE)) {
        scopes = scopes.concat(BasicPermission.READ);
    }

    if (scopes.includes(BasicPermission.ADMIN) || scopes.includes(BasicPermission.SYSTEM_ADMIN)) {
        scopes = scopes.concat(BasicPermission.READ, BasicPermission.WRITE);
    }

    if (scopes.includes(BasicPermission.JSM_KB)) {
        scopes = scopes.concat(BasicPermission.WRITE, BasicPermission.READ);
    }

    return scopes;
}

export function PermissionsBasic({ scope, availableIncomingScopes }) {
    return (
        <DropdownPermissions
            scope={scope}
            getPermissionRank={basicPermissionRank}
            scopeToSelectOption={basicScopeToSelectOption}
            selectOptions={getSelectOptions(availableIncomingScopes)}
            handleInheritedScopes={handleInheritedScopesForConfluenceAndJira}
        />
    );
}
