import React, { FC, Fragment, PropsWithChildren } from 'react';
import { css } from '@compiled/react';
import CheckCircleIcon from '@atlaskit/icon/glyph/check-circle';

import { DESCRIPTION_TITLE } from './BitbucketPermissions.i18n';

const titleStyles = css({
    marginTop: '35px',
    marginBottom: '11.67px',
});
const descriptionListStyles = css({
    display: 'contents',
});
const descriptionStyles = css({
    marginLeft: '10px',
    marginBottom: '2.5px',
});
const descriptionRowStyles = css({
    display: 'flex',
    alignItems: 'flex-end',
    marginLeft: '10px',
    marginBottom: '13px',
});
const DescriptionRow: FC<PropsWithChildren> = ({ children, ...props }) => (
    <div css={descriptionRowStyles} {...props}>
        {children}
    </div>
);

const Description: FC<PropsWithChildren> = ({ children }) => (
    <span css={descriptionStyles}>{children}</span>
);

const DescriptionList: FC<PropsWithChildren> = ({ children }) => (
    <ul css={descriptionListStyles}>{children}</ul>
);

const Title: FC<PropsWithChildren> = ({ children }) => <p css={titleStyles}>{children}</p>;

interface BitbucketPermissionDescriptionsProps {
    descriptions?: string[];
}

export default function BitbucketPermissionDescriptions({
    descriptions = [],
}: BitbucketPermissionDescriptionsProps) {
    return (
        <Fragment>
            {descriptions.length !== 0 && <Title>{DESCRIPTION_TITLE}</Title>}
            <DescriptionList>
                {descriptions.map((description, index) => {
                    return (
                        <DescriptionRow key={description + index}>
                            <CheckCircleIcon
                                label={'Check-circle-icon'}
                                primaryColor="var(--ds-icon-success)"
                            />
                            <Description>{description}</Description>
                        </DescriptionRow>
                    );
                })}
            </DescriptionList>
        </Fragment>
    );
}
