export const Product = {
    BITBUCKET: 'Bitbucket',
    CONFLUENCE: 'Confluence',
    JIRA: 'Jira',
    BAMBOO: 'Bamboo',
    REFAPP: 'Refimpl',
};

export const BitbucketPermission = {
    PUBLIC_REPOS: 'PUBLIC_REPOS',
    ACCOUNT_WRITE: 'ACCOUNT_WRITE',
    REPO_READ: 'REPO_READ',
    REPO_WRITE: 'REPO_WRITE',
    REPO_ADMIN: 'REPO_ADMIN',
    PROJECT_ADMIN: 'PROJECT_ADMIN',
    ADMIN_WRITE: 'ADMIN_WRITE',
    SYSTEM_ADMIN: 'SYSTEM_ADMIN',
};

export const BasicPermission = {
    READ: 'READ',
    WRITE: 'WRITE',
    ADMIN: 'ADMIN',
    SYSTEM_ADMIN: 'SYSTEM_ADMIN',
    JSM_KB: 'JSM_KB',
};

export const BambooPermission = {
    READ: 'READ',
    TRIGGER: 'TRIGGER',
    USER: 'USER',
};

export const allBitbucketRepoPermissions = [
    BitbucketPermission.REPO_READ,
    BitbucketPermission.REPO_WRITE,
    BitbucketPermission.REPO_ADMIN,
];
export const allBitbucketProjectPermissions = [BitbucketPermission.PROJECT_ADMIN];

export const bitbucketPermissions = new Map([
    [BitbucketPermission.PUBLIC_REPOS, []],
    [BitbucketPermission.ACCOUNT_WRITE, []],
    [BitbucketPermission.REPO_READ, []],
    [BitbucketPermission.REPO_WRITE, [BitbucketPermission.REPO_READ]],
    [
        BitbucketPermission.REPO_ADMIN,
        [BitbucketPermission.REPO_READ, BitbucketPermission.REPO_WRITE],
    ],
    [BitbucketPermission.PROJECT_ADMIN, [...allBitbucketRepoPermissions]],
    [
        BitbucketPermission.ADMIN_WRITE,
        [
            ...allBitbucketRepoPermissions,
            ...allBitbucketProjectPermissions,
            BitbucketPermission.ACCOUNT_WRITE,
        ],
    ],
    [
        BitbucketPermission.SYSTEM_ADMIN,
        [
            ...allBitbucketRepoPermissions,
            ...allBitbucketProjectPermissions,
            BitbucketPermission.ADMIN_WRITE,
            BitbucketPermission.ACCOUNT_WRITE,
        ],
    ],
]);
