import { dispatchApplinkDialogClosedEvent } from '../atlassianOauth2UiEvents';

export const createOutgoingLinkDialogInitialState = {
    isOpen: false,
    applinkId: null,
};

export function createOutgoingLinkDialogReducer(substate, action) {
    switch (action.type) {
        case 'col:open': {
            return {
                ...substate,
                isOpen: true,
                applinkId: action.detail.applinkId,
            };
        }
        case 'col:close': {
            dispatchApplinkDialogClosedEvent();
            return {
                ...substate,
                isOpen: false,
            };
        }
    }
    return substate;
}
