import { getOutgoingApplicationLinkData } from '../validators/OutgoingApplicationLink';
import { getPrefix } from '../AtlassianOauth2UiRest';

export async function getOutgoingLink(applinkId) {
    const url = `${getPrefix()}/applinks/${applinkId}/outgoing`;

    const response = await fetch(url);
    if (!response.ok) {
        throw new Error(
            'getCreateOutgoingLinkInitialState: response not ok: ' + response.statusText
        );
    }

    const responseData = await response.json();
    return getOutgoingApplicationLinkData(responseData);
}

export async function upsertOutgoingLink(applinkId, data) {
    const url = `${getPrefix()}/applinks/${applinkId}/outgoing`;

    const response = await fetch(url, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify(data),
    });
    if (!response.ok) {
        throw new Error('upsertOutgoingLink: response not ok: ' + response.statusText);
    }
}
