export function getPrefix() {
    return `${AJS.contextPath()}/rest/oauth2/latest/client`;
}

export async function postResetCredentials(clientId) {
    const url = `${getPrefix()}/reset/${clientId}`;

    const response = await fetch(url, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'X-Atlassian-Token': 'no-check',
            'Accept': 'application/json',
            'Cache-Control': 'no-cache',
        },
    });

    if (!response.ok) {
        throw new Error('postResetCredentials: response not ok: ' + response.statusText);
    }

    return await response.json();
}
