import { dispatchApplinkDialogClosedEvent } from '../atlassianOauth2UiEvents';

export const rotateCredentialsDialogInitialState = {
    expiryDate: null,
    clientId: null,
    applinkId: null,
    isRotating: false,
    hasRotationError: false,
    hasRotationSuccess: false,
    isOpen: false,
};

export function rotateCredentialsDialogReducer(substate, action) {
    switch (action.type) {
        case 'rcd:openRotateFromEvent': {
            const { detail } = action;
            const { expiryDate, clientId, applinkId } = detail;
            return {
                ...substate,
                expiryDate,
                clientId,
                applinkId,
                isOpen: true,
            };
        }
        case 'rcd:rotateStart': {
            return {
                ...substate,
                isRotating: true,
            };
        }
        case 'rcd:rotateSuccess': {
            return {
                ...substate,
                isRotating: false,
                hasRotationSuccess: true,
                hasRotationError: false,
            };
        }
        case 'rcd:rotateError': {
            return {
                ...substate,
                isRotating: false,
                hasRotationError: true,
                hasRotationSuccess: false,
            };
        }
        case 'rcd:rotateClose': {
            dispatchApplinkDialogClosedEvent();
            return {
                ...substate,
                hasRotationSuccess: false,
                hasRotationError: false,
                isOpen: false,
            };
        }
    }
    return substate;
}
