export function getPrefix() {
    return `${AJS.contextPath()}/rest/oauth2/latest`;
}

export async function postRotateCredentials(clientId) {
    const url = `${getPrefix()}/rotate/${clientId}`;

    const response = await fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Atlassian-Token': 'no-check',
            'Accept': 'application/json',
            'Cache-Control': 'no-cache',
        },
    });

    if (!response.ok) {
        throw new Error('postRotateCredentials: response not ok: ' + response.statusText);
    }

    const responseData = await response.json();
    return responseData;
}
