import Ajv from 'ajv';

const ajv = new Ajv();

const outgoingApplicationLinkSchema = {
    type: 'object',
    properties: {
        id: { type: 'string' },
        name: { type: 'string' },
        outgoingClientId: { type: 'string' },
        outgoingClientSecret: { type: 'string' },
        outgoingRedirectUri: { type: 'string' },
        availableOutgoingScopes: { type: 'array', items: { type: 'string' } },
        outgoingScopes: { type: 'array', items: { type: 'string' } },
        outgoingPresent: { type: 'boolean' },
        outgoingDataIsStale: { type: 'boolean' },
        readonlyOutgoingScopes: { type: 'boolean' },
    },
    required: ['id', 'outgoingRedirectUri', 'availableOutgoingScopes', 'readonlyOutgoingScopes'],
    additionalProperties: true,
};

const validateOutgoingApplicationLink = ajv.compile(outgoingApplicationLinkSchema);

export function getOutgoingApplicationLinkData(responseData) {
    const valid = validateOutgoingApplicationLink(responseData);
    if (!valid) {
        console.error(
            'getOutgoingApplicationLinkData: schema validation errors',
            ...validateOutgoingApplicationLink.errors
        );
        throw new Error(
            `outgoingApplicationLink doesn't conform to schema: ${JSON.stringify(responseData)}`
        );
    } else {
        return responseData;
    }
}
