import React, { StrictMode } from 'react';
import { createRoot } from 'react-dom/client';
import EntityLinks from './entity-links';

export function initLinks(el, data) {
    const { entityLinks, applicationLinks, currentApp, projectKey, type } = data;
    const root = createRoot(el);

    root.render(
        <StrictMode>
            <EntityLinks
                entityLinks={entityLinks}
                applicationLinks={applicationLinks}
                currentApp={currentApp}
                projectKey={projectKey}
                type={type}
            />
        </StrictMode>
    );
}
