AJS.$(document).bind(AppLinks.Event.READY, function() {
    (function($) {

        var selectedApplicationLinkId;
        var selectedApplicationName;
        var selectedApplicationType;
        var applicationSupportsUAL = false;
        var typeSelect = $("#add-non-ual-entity-link-type");
        var canCreateReciprocalLink = false;
        var selectedRemoteEntity;

        var showErrorMessage = function(message) {
            AppLinks.UI.showErrorBox(message);
        };

        var remoteEntities = new Array();
        var configuredEntities = new Array();

        function translateRemoteEntityToSelect2EntityData(entity) {
            return {
                id: `${entity.key}_${entity.name}`,
                entity: entity
            };
        }

        var loadEntities = function(applicationLinkID, anonymousAccess) {
            var handleLoadEntities = function(data) {
                remoteEntities = new Array();
                //These types of entities are available from the remote system.
                var availableRemoteEntityTypes = {};
                for (var i = 0; i < data.entity.length; i++) {
                    var entity = data.entity[i];
                    var configured = false;
                    $(configuredEntities).each( function(index) {
                        if (configuredEntities[index].key === entity.key &&
                            configuredEntities[index].typeId === entity.typeId) {
                            configured = true;
                        }
                    });
                    if (!configured) {
                        remoteEntities.push(entity);
                    }
                }

                $.each(remoteEntities, function(i,v) {
                    if ( !availableRemoteEntityTypes[v.typeId]) {
                        availableRemoteEntityTypes[v.typeId] = 1;
                    } else {
                        var num = availableRemoteEntityTypes[v.typeId];
                        availableRemoteEntityTypes[v.typeId] = num + 1;
                    }
                });
                var message;
                $('.ual-entity-links').each(function() {
                    $(this).show();
                });

                if (remoteEntities.length === 1) {
                    $('#add-entity-link-entity').auiSelect2('val', translateRemoteEntityToSelect2EntityData(remoteEntities[0]).id, true);
                }

                if (remoteEntities.length == 1) {
                    var entityLabel;

                    //availableRemoteEntityTypes is a JS object and works like a map.
                    //It contains in this case only one entry, which is the type of the unlinked entity.
                    $.each(availableRemoteEntityTypes, function(key) {
                        entityLabel = AppLinks.I18n.getEntityTypeName(key);
                    });
                    message = anonymousAccess ?
                        AJS.I18n.getText('applinks.entity.links.one.link.available.anonymous', entityLabel) :
                        AJS.I18n.getText('applinks.entity.links.one.link.available', entityLabel);

                    if (!anonymousAccess && canCreateReciprocalLink) {
                        $('.create-reciprocal-entity-link-label').text(AJS.I18n.getText('applinks.entity.links.create.reciprocal.link.yes', [entityLabel, remoteEntities[0].name, localEntity.attr('data-type-label'), localEntity.attr('data-name')]));
                        $('.no-reciprocal-entity-link-label').text(AJS.I18n.getText('applinks.entity.links.create.reciprocal.link.no', [entityLabel, remoteEntities[0].name, localEntity.attr('data-type-label'), localEntity.attr('data-name')]));
                        $('#create-reciprocal-entity-link').prop('checked', true);
                        $('.reciprocate-entity-link').show();
                    }

                    addEntityLinkWizard.enableSubmitBtn();
                } else if (remoteEntities.length == 0) {

                    if (configuredEntities.length == 0) {
                      message = anonymousAccess ?
                          AJS.I18n.getText('applinks.entity.links.no.links.accessible.anonymous') :
                          AJS.I18n.getText('applinks.entity.links.no.links.accessible');
                    } else {
                      message = anonymousAccess ?
                          AJS.I18n.getText('applinks.entity.links.no.links.available.anonymous') :
                          AJS.I18n.getText('applinks.entity.links.no.links.available');
                    }
                    $('.ual-entity-links').each( function() {
                        $(this).hide();
                    });
                    addEntityLinkWizard.disableSubmitBtn(false);
                } else {
                    var labels = "";
                    $.each(availableRemoteEntityTypes, function(i,v) {
                        if (labels != "") {
                            labels += ", ";
                        }
                        labels += v + " " + AppLinks.I18n.getPluralizedEntityTypeName(i);
                    });
                    message = anonymousAccess ?
                        AJS.I18n.getText('applinks.entity.links.multiple.links.available.anonymous', labels) :
                        AJS.I18n.getText('applinks.entity.links.multiple.links.available', labels);
                    addEntityLinkWizard.disableSubmitBtn(false);
                }
                $('#available-entities-msg').show();
                $('#available-entities-msg').text(message);
                $('.entity-loading').remove();
            };
            if (anonymousAccess) {
                AppLinks.SPI.getEntityLinksForApplicationUsingAnonymousAccess(applicationLinkID, handleLoadEntities, AppLinks.UI.displayValidationError('validation-ual-error', dialogRootEl))
            } else {
                AppLinks.SPI.getEntityLinksForApplication(applicationLinkID, handleLoadEntities, AppLinks.UI.displayValidationError('validation-ual-error', dialogRootEl));
            }
        };

        var loadEntityTypes = function(type) {

            var populateTypeSelect = function(data) {
                AppLinks.UI.hideLoadingIcon(typeSelect);
                var message = AppLinks.UI.prettyJoin(data.entityTypes, function(entityType) {
                    return AppLinks.I18n.getEntityTypeName(entityType.typeId);
                }, AJS.I18n.getText('applinks.or'));

                $('.non-ual-entity-msg').html( AJS.I18n.getText('applinks.entity.links.message', message) );
                var entityCount = data.entityTypes.length;
                if (entityCount < 1) {
                    AppLinks.failure(AJS.I18n.getText("applinks.entity.links.error.no.entity.types.for.application"));
                    return;
                } else if (entityCount === 1) {
                    var entityType = data.entityTypes[0];
                    typeSelect.html("<span class='field-value' id='add-non-ual-entity-link-type'>" + AppLinks.I18n.getEntityTypeName(entityType.typeId) + "</span> <input type='hidden' class='selected-entity-type' value='" + entityType.typeId +"'/>");
                    $('#add-non-ual-entity-link-entity').focus();
                } else {
                    var selectDropDown = $('<select tabindex="3" class="selected-entity-type"></select>');
                    typeSelect.html(selectDropDown);
                    for (var i = 0; i < data.entityTypes.length; i++) {
                        var entityType = data.entityTypes[i];
                        selectDropDown.append("<option value='" + entityType.typeId + "'>" + AppLinks.I18n.getEntityTypeName(entityType.typeId) + "</option>");
                    }
                }
                addEntityLinkWizard.enableSubmitBtn();
                $("div.non-ual-links").show();
            };
            AppLinks.SPI.getEntityTypesForApplicationType(type, populateTypeSelect, AppLinks.UI.displayValidationError('validation-error', dialogRootEl));
        };

        var localEntity = AJS.$("#add-entity-link-local");
        var localType = localEntity.attr("data-type");
        var localKey = localEntity.attr("data-key");

        var loadConfiguredEntities = function(applicationLinkId, successCallback) {
            configuredEntities = new Array();
            AppLinks.SPI.getConfiguredEntityLinks(localType, localKey, function(data) {
                $.each(data, function(index, value) {
                    var entitiesOfRemoteType = value;
                    $.each(entitiesOfRemoteType, function(i, v) {
                        if (v.applicationId == applicationLinkId) {
                            configuredEntities.push(v);
                        }
                    })
                });
                successCallback();
            }, AppLinks.UI.displayValidationError('validation-error', dialogRootEl));
        };

        var createLink = function(entity, applicationLinkId) {
            if (!entity) {
                $("#select-entity-ual div.error").text(AJS.I18n.getText("applinks.entity.links.error.not.found"));
                return;
            }
            var reciprocateRButton = $("#create-reciprocal-entity-link");
            var reciprocate = !reciprocateRButton.is(":disabled") && reciprocateRButton.is(":checked");
            addEntityLinkWizard.disableSubmitBtn();
            AppLinks.SPI.createEntityLink(
            localType, localKey, AJS.$.extend({
                applicationId: applicationLinkId
            }, entity), reciprocate, function() {
                addEntityLinkWizard.enableSubmitBtn();
                addEntityLinkWizard.cancel();
                AppLinks.UI.listEntityLinks();
                var label = localEntity.attr('data-type-label');
                var name  = localEntity.attr('data-name');
                var remoteLabel = AppLinks.I18n.getEntityTypeName(entity.typeId);
                AppLinks.UI.showInfoBox(AJS.$('<span>').text(AJS.I18n.getText("applinks.entity.create", label, name, remoteLabel, entity.name)));
            }, AppLinks.UI.displayValidationError('validation-ual-error', dialogRootEl, function() {
                addEntityLinkWizard.enableSubmitBtn();
            })
            );
        };

        var initUALUI = function(anonymous) {
            $('#available-entities-msg').hide();
            $('.reciprocate-entity-link').hide();

            $('.entity-loading-message').append('<div class="entity-loading">'
                + '<aui-spinner size="small" class="applinks-loading"></aui-spinner> '
                + AJS.I18n.getText('applinks.entity.links.loading') + '</div>');
            var successFn = function () {
               loadEntities(selectedApplicationLinkId, anonymous);
            }
            addEntityLinkWizard.disableSubmitBtn(false);
            loadConfiguredEntities(selectedApplicationLinkId, successFn);
        }

        var gotoSelectEntity = function(canCreateLink, anonymous) {
            canCreateReciprocalLink = canCreateLink;
            addEntityLinkWizard.dialog.gotoPage(1);
            addEntityLinkWizard.dialog.gotoPanel(0);
            initUALUI(anonymous);
        }

        var authenticationRequired = function(authUrl) {
            if (authUrl) {
                var callbacks = {
                    before: function() {
                        addEntityLinkWizard.dialog.hide();
                    },
                    onSuccess: function() {
                        var settings = {
                            noPermission: function() {
                                gotoSelectEntity(false, false);
                                addEntityLinkWizard.dialog.show();
                            },
                            missing: function() {
                                gotoSelectEntity(false, false);
                                addEntityLinkWizard.dialog.show();
                            },
                            noAuthentication: function() {
                                gotoSelectEntity(false, true);
                                addEntityLinkWizard.dialog.show();
                            },
                            authenticationFailed: function() {
                                gotoSelectEntity(false, true);
                                addEntityLinkWizard.dialog.show();
                            },
                            credentialsRequired: function() {
                                gotoSelectEntity(false, true);
                                addEntityLinkWizard.dialog.show();
                            },
                            noConnection: function() {
                                addEntityLinkWizard.dialog.close();
                                showErrorMessage(AJS.I18n.getText("applinks.dialog.connection.failed", AppLinks.UI.sanitiseHTML(selectedApplicationName)));
                            },
                            allowed: function() {
                                gotoSelectEntity(true, false);
                                addEntityLinkWizard.dialog.show();
                            },
                            unrecognisedCode: function(code) {
                                addEntityLinkWizard.dialog.close();
                                showErrorMessage(AJS.I18n.getText("applinks.dialog.invalid.permission.code", code));
                            }
                        };
                        AppLinks.SPI.canCreateReciprocateEntityLink(selectedApplicationLinkId, AppLinks.SPI.processPermissionCode(settings));
                    },
                    onFailure: function() {
                        $('.applinks-error').remove();
                        $('<div class="error applinks-error">' + AJS.I18n.getText('applinks.dialog.entity.link.authorization.failed') + '</div>').insertAfter('#authorization-form-msg');
                        addEntityLinkWizard.dialog.show();
                    }
                }
                addEntityLinkWizard.dialog.gotoPage(0);
                addEntityLinkWizard.dialog.gotoPanel(0);
                addEntityLinkWizard.dialog.show();
                $('#skip-link').off('click.applinks');
                $('#skip-link').on('click.applinks', function() {
                    canCreateReciprocalLink = false;
                    addEntityLinkWizard.dialog.gotoPage(1);
                    initUALUI(true);
                });
                AppLinks.SPI.addAuthenticationTrigger("#authorize-link", authUrl, callbacks);
            } else {
                canCreateReciprocalLink = false;
                addEntityLinkWizard.dialog.gotoPage(1);
                initUALUI(true);
                addEntityLinkWizard.dialog.show();
            }
        };

        var settings = {
            width: 500,
            height: 450,
            id: "add-entity-link-wizard",
            cancelLabel: AJS.I18n.getText("applinks.cancel"),
            onsubmit: function() {
                $('.applinks-error').remove();
                if (applicationSupportsUAL) {
                    createLink(selectedRemoteEntity, selectedApplicationLinkId);
                } else {
                    var remoteKey = $.trim($('#add-non-ual-entity-link-entity').val());
                    if (remoteKey.length == 0) {
                        $('#select-entity-non-ual div.error').text(AJS.I18n.getText('applinks.entity.links.entity.key.is.empty'));
                        return; //just whitespace
                    }
                    var remoteName = $.trim($('#add-non-ual-entity-link-alias').val());
                    var exists = false;
                    $.each(configuredEntities, function(index, value) {
                        if (value.key == remoteKey) {
                            $('#select-entity-non-ual div.error').text(AJS.I18n.getText('applinks.entity.links.entity.key.exists'));
                            exists = true;
                        }
                    });
                    if (exists == true) {
                        return;
                    }
                    addEntityLinkWizard.disableSubmitBtn();
                    AppLinks.SPI.createNonUalEntityLink(localType, localKey, selectedApplicationLinkId, typeSelect.find('.selected-entity-type').val(), remoteKey, remoteName, function() {
                        addEntityLinkWizard.enableSubmitBtn();
                        AppLinks.UI.listEntityLinks();
                        var label = localEntity.attr('data-type-label');
                        var name  = localEntity.attr('data-name');
                        var remoteLabel = AppLinks.I18n.getEntityTypeName(typeSelect.find('.selected-entity-type').val());
                        AppLinks.UI.showInfoBox($('<span>').text(AJS.I18n.getText("applinks.entity.create", label, name, remoteLabel, remoteName)));
                        addEntityLinkWizard.cancel();
                    }, AppLinks.UI.displayValidationError('validation-non-ual-error', dialogRootEl, function() {
                            addEntityLinkWizard.enableSubmitBtn();
                       }));
                }
            },
            onnext: function() {

                return true;
            },
            onprevious: function() {
                return true;
            },
            onshow: function(popup, configuration) {
                $('.applinks-error').remove();
                if (applicationSupportsUAL) {
                    selectedRemoteEntity = null;
                    $('#add-entity-link-entity').auiSelect2('val', '');
                    $("#select-entity-ual div.error").text('');
                } else {
                    $('#add-non-ual-entity-link-entity').val('');
                    $('#add-non-ual-entity-link-alias').val('');
                    $('#select-entity-non-ual div.error').text('');
                }

                var settings = {
                    noPermission: function() {
                        gotoSelectEntity(false, false);
                        addEntityLinkWizard.dialog.show();
                    },
                    missing: function() {
                        gotoSelectEntity(false, false);
                        addEntityLinkWizard.dialog.show();
                    },
                    noAuthentication: authenticationRequired,
                    authenticationFailed: authenticationRequired,
                    credentialsRequired: authenticationRequired,
                    noConnection: function() {
                        showErrorMessage(AJS.I18n.getText("applinks.dialog.connection.failed", AppLinks.UI.sanitiseHTML(selectedApplicationName)));
                    },
                    allowed: function() {
                        gotoSelectEntity(true, false);
                        addEntityLinkWizard.dialog.show();
                    },
                    unrecognisedCode: function(code) {
                        showErrorMessage(AJS.I18n.getText("applinks.dialog.invalid.permission.code", code));
                    }
                };
                if (applicationSupportsUAL) {

                    $('#create-reciprocal-entity-link').prop('checked', false);
                    $('#no-reciprocal-entity-link').prop('checked', false);

                    AppLinks.SPI.canCreateReciprocateEntityLink(selectedApplicationLinkId, AppLinks.SPI.processPermissionCode(settings));
                } else {
                    typeSelect.find('select').remove();
                    AppLinks.UI.showLoadingIcon(typeSelect);
                    var successFn = function () {
                        loadEntityTypes(selectedApplicationType);
                    }
                    addEntityLinkWizard.disableSubmitBtn();
                    loadConfiguredEntities(selectedApplicationLinkId, successFn);
                    addEntityLinkWizard.dialog.gotoPage(2);
                    addEntityLinkWizard.dialog.gotoPanel(0);
                    addEntityLinkWizard.dialog.show();
                }
                return false;
            }
        }
        var addEntityLinkWizard = $("#add-entity-link-dialog").wizard(settings);
        var dialogRootEl     = $(addEntityLinkWizard.dialog.popup.element);
        $("#add-entity-link-wizard h2.dialog-title").append(AppLinks.Docs.createDocLinkIcon("applinks.docs.adding.entity.link", null, 'dialog-help-link'));


        function getSelectEntityItemText(namePart, keyPart) {
            return `${namePart} ( ${keyPart} )`;
        }

        AJS.$("#add-entity-link-entity").auiSelect2({
            placeholder: AJS.I18n.getText('applinks.entity.links.select.an.entity'),
            minimumResultsForSearch: 2,
            multiple: false,
            closeOnSelect: true,
            query: function (query) {
                const data = remoteEntities
                  .filter(entity => this.matcher(query.term, getSelectEntityItemText(entity.name, entity.key)))
                  .filter(entity => configuredEntities.every(configuredEntity => configuredEntity.displayUrl !== entity.displayUrl))
                  .map(translateRemoteEntityToSelect2EntityData);

                query.callback({results: data});
            },
            initSelection: function(element, callback) {
                if (remoteEntities.length === 1) {
                    const entity = translateRemoteEntityToSelect2EntityData(remoteEntities[0])
                    if (element.val() !== entity.id) {
                        AJS.log(`Element value (${element.val()}) does not match the expected entity.id (${entity.id})`);
                    }

                    callback(entity);
                }
            },
            formatResult: function(state) {
                function getOptionalEntityIconMarkup(entity) {
                    return entity.iconUrl ? `<img src="${entity.iconUrl}" height="16px" style="vertical-align:middle">&nbsp;` : '';
                }
                function wrapAsRemoteEntity(markup) {
                    return `<span class="remote-entity">${markup}</span>`;
                }

                const entity = state.entity;

                const MAX_NAME_LENGTH = 20;
                const briefNamePart = entity.name.length > MAX_NAME_LENGTH ? entity.name.substring(0, MAX_NAME_LENGTH) + "…" : entity.name;

                return wrapAsRemoteEntity(getOptionalEntityIconMarkup(entity) + getSelectEntityItemText(briefNamePart, entity.key));
            },
            formatSelection: function(state) {
                return state.entity.name;
            }
        }).on("change", function(e) {
            const entity = e.added.entity;
            selectedRemoteEntity = entity;

            if (canCreateReciprocalLink) {
                $('.reciprocate-entity-link').show();

                $('#create-reciprocal-entity-link').prop('checked', true);
                $('#no-reciprocal-entity-link').prop('checked', false);

                $('.create-reciprocal-entity-link-label').text(AJS.I18n.getText('applinks.entity.links.create.reciprocal.link.yes', AppLinks.I18n.getEntityTypeName(entity.typeId), entity.name, localEntity.attr('data-type-label'), localEntity.attr('data-name')));
                $('.no-reciprocal-entity-link-label').text(AJS.I18n.getText('applinks.entity.links.create.reciprocal.link.no', AppLinks.I18n.getEntityTypeName(entity.typeId), entity.name, localEntity.attr('data-type-label'), localEntity.attr('data-name')));
            } else {
                $('.reciprocate-entity-link').hide();

                $('#create-reciprocal-entity-link').prop('checked', false);
                $('#no-reciprocal-entity-link').prop('checked', false);
            }

            addEntityLinkWizard.enableSubmitBtn();
        });

        /**
         * Attach on click event to all application links in select drop down.
         */
        $('.item-link').on('click', function(e) {
                e.preventDefault();
                selectedApplicationLinkId = $(this).attr('data-key');
                selectedApplicationName   = $(this).attr('data-name');
                selectedApplicationType = $(this).attr('data-type')
                if ($(this).attr('data-ual')) {
                    applicationSupportsUAL = true;
                } else {
                    applicationSupportsUAL = false;
                }
                AppLinks.UI.hideInfoBox();
                addEntityLinkWizard.show();
        });

        $('#add-non-ual-entity-link-entity').on('keydown', function(event) {
            //KeyCode 13 is the enter key.
            if (event.keyCode == '13') {
                addEntityLinkWizard.submit();
            }
        });

    })(AJS.$)
});
