define('applinks/common/page-initializer', [
    'applinks/lib/wrm',
    'applinks/common/modules',
    'applinks/lib/jquery',
], (WRM, ApplinksModules, $) => {
    const initializerData = WRM.data.claim(
        ApplinksModules.dataFqn('applinks-page-initializer', 'applinks-page-initializer-data')
    );
    if (initializerData) {
        let pageInitializer = initializerData.pageInitializer;
        let pageType = initializerData.pageType;
        let pageSize = initializerData.pageSize;

        $(document).ready(() => {
            if (pageInitializer) {
                require(pageInitializer).init();
            }

            $(document.body).addClass(pageType ? 'aui-page-' + pageType : '');
            $(document.body).addClass('aui-page-' + (pageSize || 'xlarge'));
        });
    }
});

require('applinks/common/page-initializer');
