'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

define('bitbucket-plugin-git-lfs/internal/feature/file-lock/lfs-file-lock', ['@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/util/analytics', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/events', 'bitbucket/internal/util/time', 'bitbucket/util/state', 'exports'], function (AJS, $, _, analytics, nav, server, events, time, pageState, exports) {
    var fileLocked = false;
    var lockInfo = void 0;

    var $container = $('.content-view.source-view');
    var $breadcrumbs = $('.breadcrumbs');

    var replaceButtonText = function replaceButtonText() {
        var $button = $('.lock-file-button');
        var buttonText = fileLocked ? AJS.I18n.getText('bitbucket.scm.git.lfs.unlock.button') : AJS.I18n.getText('bitbucket.scm.git.lfs.lock.button');

        $button.text(buttonText);
    };

    var toggleLockIcon = function toggleLockIcon() {
        if (fileLocked) {
            var $lockEl = $(bitbucketPluginGitLfs.internal.fileHandlers.lfsFileViews.lfsFileLockIcon({
                lock: lockInfo
            }));

            $lockEl.tooltip({
                gravity: 'n'
            });

            $breadcrumbs.append($lockEl);
        }

        if (!fileLocked) {
            $breadcrumbs.find('.aui-icon.lock').remove();
        }
    };

    var formatLockData = function formatLockData(lock) {
        var lockedAt = time.format(lock['locked_at'], 'full');

        return {
            author: lock.owner.name,
            authorId: lock.owner.id,
            date: lockedAt,
            id: lock.id
        };
    };

    var updateLocks = function updateLocks(response) {
        fileLocked = !fileLocked;
        lockInfo = formatLockData(response.lock);

        replaceButtonText();
        toggleLockIcon();

        var flagBody = fileLocked ? AJS.I18n.getText('bitbucket.scm.git.lfs.lock.success.flag') : AJS.I18n.getText('bitbucket.scm.git.lfs.unlock.success.flag');

        showSuccessFlag(flagBody);
    };

    var showSuccessFlag = function showSuccessFlag(body) {
        AJS.flag({
            close: 'auto',
            body: body,
            title: AJS.I18n.getText('bitbucket.scm.git.lfs.lock.success.flag.title'),
            type: 'success'
        });
    };

    var lockRequest = function lockRequest(url, data) {
        var restConfig = {
            url: url,
            type: 'POST',
            data: data,
            dataType: 'json',
            accepts: {
                json: 'application/vnd.git-lfs+json; charset=UTF-8'
            },
            contentType: 'application/vnd.git-lfs+json; charset=UTF-8',
            statusCode: {
                '*': function _(xhr, textStatus, errorThrown, errors, dominantError) {
                    if (errors && errors.message) {
                        setButtonDisabled(false);

                        return _extends({}, dominantError, {
                            title: AJS.I18n.getText('bitbucket.scm.git.lfs.request.status.failed'),
                            message: errors && errors.message,
                            fallbackUrl: false,
                            shouldReload: true
                        });
                    }

                    return false;
                }
            }
        };

        setButtonDisabled(true);

        return server.rest(restConfig).then(function (response) {
            setButtonDisabled(false);
            updateLocks(response);
        });
    };

    var setButtonDisabled = function setButtonDisabled(disabled) {
        var $button = $('.lock-file-button');
        $button.prop('disabled', disabled).toggleClass('disabled', disabled);
        $button.attr('aria-disabled', disabled);
    };

    var addAnalytics = function addAnalytics(eventName, extraProps) {
        var repoId = pageState.getRepository().id;
        var projId = pageState.getProject().id;

        analytics.add(eventName, _extends({
            'repository.id': repoId,
            'repository.project.id': projId
        }, extraProps));
    };

    var lockFile = function lockFile() {
        var pathAndFileName = pageState.getFilePath().components.join('/');
        var url = nav.repository(pageState.getRepository()).clone('git').addPathComponents('info', 'lfs', 'locks').build();
        var data = {
            path: pathAndFileName
        };

        addAnalytics('stash.client.git.lfs.lock.button.clicked');

        lockRequest(url, data);
    };

    var unlockFile = function unlockFile() {
        var force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

        var url = nav.repository(pageState.getRepository()).clone('git').addPathComponents('info', 'lfs', 'locks', lockInfo.id, 'unlock').build();
        var data = {
            force: force
        };

        addAnalytics('stash.client.git.lfs.unlock.button.clicked', {
            force: force
        });

        lockRequest(url, data);
    };

    var createForceUnlockDialog = function createForceUnlockDialog() {
        var unlockModalButton = aui.buttons.button({
            text: AJS.I18n.getText('bitbucket.scm.git.lfs.unlock.button'),
            type: 'primary',
            extraClasses: ['modal-unlock-button']
        });

        var modalCancelButton = aui.buttons.button({
            text: AJS.I18n.getText('bitbucket.web.button.cancel'),
            type: 'link',
            extraClasses: 'modal-cancel-button'
        });

        $container.append(aui.dialog.dialog2({
            content: AJS.I18n.getText('bitbucket.scm.git.lfs.unlock.dialog.body', _.escape(lockInfo.author), lockInfo.date),
            modal: true,
            removeOnHide: true,
            id: 'confirm-force-unlock',
            size: 'small',
            titleText: AJS.I18n.getText('bitbucket.scm.git.lfs.unlock.dialog.title'),
            footerActionContent: modalCancelButton + unlockModalButton
        }));

        var dialog = AJS.dialog2('#confirm-force-unlock');

        dialog.show();

        $('.modal-cancel-button').click(function () {
            dialog.hide();
        });

        $('.modal-unlock-button').click(function () {
            unlockFile(true);
            dialog.hide();
        });
    };

    var setLockButtonHandler = function setLockButtonHandler() {
        var $button = $('.lock-file-button');

        $button.click(function () {
            if (fileLocked) {
                var userId = pageState.getCurrentUser().id;
                var _lockInfo = lockInfo,
                    authorId = _lockInfo.authorId;


                if (authorId !== userId) {
                    createForceUnlockDialog();
                } else {
                    unlockFile();
                }
            } else {
                lockFile();
            }
        });
    };

    var init = function init() {
        events.on('bitbucket.internal.DO_NOT_USE.layout.files.lfs.locked', function (lockData) {
            lockInfo = lockData;
            fileLocked = true;
        });

        events.on('bitbucket.internal.DO_NOT_USE.feature.fileContent.requestHandled', function () {
            if (fileLocked) {
                replaceButtonText();
            }
            setLockButtonHandler();
        });
    };

    exports.onReady = function () {
        init();
    };
});