define('bitbucket-plugin-notification/internal/feature/repositories/settings/settings', ['exports', '@atlassian/aui', 'react', 'react-dom', 'react-redux', '../watch-settings-state/action-creators', '../watch-settings-state/store', './watched-repositories'], function (exports, _aui, _react, _reactDom, _reactRedux, _actionCreators, _store, _watchedRepositories) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _store2 = _interopRequireDefault(_store);

    var _watchedRepositories2 = _interopRequireDefault(_watchedRepositories);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var RepositoryNotificationSettings = function RepositoryNotificationSettings(_ref) {
        var store = _ref.store;

        var introHtml = {
            __html: _aui.I18n.getText('bitbucket.notification.repository.settings.intro.html', bitbucket_help_url('bitbucket.help.notifications.repository'))
        };

        return _react2.default.createElement(
            _reactRedux.Provider,
            { store: store },
            _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h2',
                    null,
                    _aui.I18n.getText('bitbucket.notification.repository.settings.title')
                ),
                _react2.default.createElement('p', { dangerouslySetInnerHTML: introHtml }),
                _react2.default.createElement(_watchedRepositories2.default, null)
            )
        );
    }; /* global bitbucket_help_url:false */


    function init(container) {
        if (!container.dataset.settings) {
            console.error('Missing initial settings data.');

            return;
        }

        var initialData = JSON.parse(container.dataset.settings);

        if (initialData) {
            _store2.default.dispatch((0, _actionCreators.hydrate)(initialData));
        }
        container.removeAttribute('data-settings');
        _reactDom2.default.render(_react2.default.createElement(RepositoryNotificationSettings, { store: _store2.default }), container);
    }

    exports.init = init;
});