define('bitbucket-plugin-notification/internal/feature/repositories/settings/watched-repositories-list', ['module', 'exports', '@atlassian/aui', 'lodash', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/bbui/paged-table/paged-table', 'bitbucket/internal/widget/icons/icons', '../settings-types', '../watch-settings-state/save-types'], function (module, exports, _aui, _lodash, _propTypes, _react, _avatar, _spinner, _pagedTable, _icons, _settingsTypes, _saveTypes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    var _pagedTable2 = _interopRequireDefault(_pagedTable);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var commitSettingLabel = function commitSettingLabel(repository) {
        switch (repository.settings[_settingsTypes.SETTING_COMMITS]) {
            case _settingsTypes.SettingCommitsValues.DEFAULT_BRANCH:
                return _react2.default.createElement(
                    'span',
                    { className: 'repository-default-branch' },
                    repository.defaultBranch ? [_react2.default.createElement(_icons.BranchIcon, null), _react2.default.createElement(
                        'span',
                        { key: 'name', className: 'branch-name' },
                        repository.defaultBranch
                    )] : [_aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits.default.nobranch')]
                );
            case _settingsTypes.SettingCommitsValues.ALL:
                return _aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits.all');
            case _settingsTypes.SettingCommitsValues.NONE:
                return _aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits.none');
        }
    };

    var pullRequestSettingLabel = function pullRequestSettingLabel(repository) {
        switch (repository.settings[_settingsTypes.SETTING_PULL_REQUESTS]) {
            case _settingsTypes.SettingPullRequestsValues.STATE_CHANGES:
                return _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr.state');
            case _settingsTypes.SettingPullRequestsValues.ALL:
                return _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr.all');
            case _settingsTypes.SettingPullRequestsValues.NONE:
                return _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr.none');
        }
    };

    // Compare repository settings to the "None" settings constant
    var isWatching = function isWatching(repository) {
        return !(0, _lodash.isEqual)(repository.settings, _settingsTypes.UNWATCH_SETTINGS);
    };
    var isWatchUnwatchPending = function isWatchUnwatchPending(saveState) {
        return saveState === _saveTypes.SAVE_TYPE_WATCH || saveState === _saveTypes.SAVE_TYPE_UNWATCH;
    };
    var RepositoryRow = function RepositoryRow(_ref) {
        var onEdit = _ref.onEdit,
            onUnwatchRepository = _ref.onUnwatchRepository,
            onWatchRepository = _ref.onWatchRepository,
            repository = _ref.repository,
            saveState = _ref.saveState;
        return _react2.default.createElement(
            'tr',
            { key: repository.id, className: 'repository-row' },
            _react2.default.createElement(
                'td',
                { className: 'repository-cell' },
                _react2.default.createElement(
                    'div',
                    { className: 'repository-name' },
                    _react2.default.createElement(_avatar.ProjectAvatar, {
                        className: 'project-avatar',
                        project: repository.project,
                        size: 'xsmall'
                    }),
                    _react2.default.createElement(
                        'div',
                        { className: 'project' },
                        repository.project.name
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'repository' },
                        _react2.default.createElement(
                            'a',
                            { href: repository.links.self[0].href },
                            repository.name
                        )
                    )
                )
            ),
            _react2.default.createElement(
                'td',
                {
                    className: 'setting-cell commit-notification-scope',
                    'data-scope': repository.settings[_settingsTypes.SETTING_COMMITS]
                },
                commitSettingLabel(repository)
            ),
            _react2.default.createElement(
                'td',
                {
                    className: 'setting-cell pull-request-notification-scope',
                    'data-scope': repository.settings[_settingsTypes.SETTING_PULL_REQUESTS]
                },
                pullRequestSettingLabel(repository)
            ),
            _react2.default.createElement(
                'td',
                { className: 'actions-cell' },
                _react2.default.createElement(
                    'div',
                    { className: 'repository-actions' },
                    _react2.default.createElement(
                        'button',
                        {
                            className: 'aui-button aui-button-link edit-repository-settings',
                            disabled: isWatchUnwatchPending(saveState),
                            onClick: function onClick() {
                                return onEdit(repository);
                            }
                        },
                        _aui.I18n.getText('bitbucket.web.button.edit')
                    ),
                    isWatchUnwatchPending(saveState) ? _react2.default.createElement(_spinner2.default, null) : _react2.default.createElement(
                        'button',
                        {
                            className: 'aui-button aui-button-link toggle-watch-repository',
                            onClick: function onClick() {
                                if (isWatching(repository)) {
                                    onUnwatchRepository(repository);
                                } else {
                                    onWatchRepository(repository);
                                }
                            }
                        },
                        isWatching(repository) ? _aui.I18n.getText('bitbucket.notification.unwatch') : _aui.I18n.getText('bitbucket.notification.watch')
                    )
                )
            )
        );
    };

    var Header = function Header() {
        return _react2.default.createElement(
            'tr',
            { key: 'header' },
            _react2.default.createElement(
                'th',
                { className: 'repository-header' },
                _aui.I18n.getText('bitbucket.notification.settings.header.repository')
            ),
            _react2.default.createElement(
                'th',
                { className: 'setting-commits-header' },
                _aui.I18n.getText('bitbucket.notification.settings.header.commits')
            ),
            _react2.default.createElement(
                'th',
                { className: 'setting-pull-requests-header' },
                _aui.I18n.getText('bitbucket.notification.settings.header.pullrequests')
            ),
            _react2.default.createElement(
                'th',
                { className: 'actions-header' },
                _aui.I18n.getText('bitbucket.notification.settings.header.actions')
            )
        );
    };

    var WatchedRepositoriesList = function WatchedRepositoriesList(_ref2) {
        var repositories = _ref2.repositories,
            paging = _ref2.paging,
            _ref2$loading = _ref2.loading,
            loading = _ref2$loading === undefined ? false : _ref2$loading,
            onEditRepositorySettings = _ref2.onEditRepositorySettings,
            onLoadMoreRepositories = _ref2.onLoadMoreRepositories,
            onUnwatchRepository = _ref2.onUnwatchRepository,
            onWatchRepository = _ref2.onWatchRepository,
            repositorySaveState = _ref2.repositorySaveState;
        return _react2.default.createElement(_pagedTable2.default, {
            className: 'watched-repositories-list',
            allFetched: paging.isLastPage,
            allFetchedMessage: _aui.I18n.getText('bitbucket.web.repository.allfetched'),
            items: repositories,
            loading: loading,
            onMoreItemsRequested: function onMoreItemsRequested() {
                return onLoadMoreRepositories(paging.nextPageStart);
            },
            header: _react2.default.createElement(Header, null),
            row: function row(_ref3) {
                var repository = _ref3.item;
                return _react2.default.createElement(RepositoryRow, {
                    key: repository.id,
                    onEdit: onEditRepositorySettings,
                    onUnwatchRepository: onUnwatchRepository,
                    onWatchRepository: onWatchRepository,
                    repository: repository,
                    saveState: repositorySaveState[repository.id]
                });
            }
        });
    };

    WatchedRepositoriesList.propTypes = {
        repositories: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
        paging: _propTypes2.default.object.isRequired,
        loading: _propTypes2.default.bool,
        onEditRepositorySettings: _propTypes2.default.func.isRequired,
        onLoadMoreRepositories: _propTypes2.default.func.isRequired,
        onUnwatchRepository: _propTypes2.default.func.isRequired,
        repositorySaveState: _propTypes2.default.object.isRequired
    };

    exports.default = WatchedRepositoriesList;
    module.exports = exports['default'];
});