define('bitbucket-plugin-notification/internal/feature/repositories/settings/watched-repositories', ['exports', '@atlassian/aui', 'prop-types', 'react', 'react-redux', 'bitbucket/internal/util/analytics', 'bitbucket/util/state', '../settings-types', '../watch-settings-dialog/watched-repositories-settings-dialog', '../watch-settings-state/action-creators', '../watch-settings-state/save-types', '../watch-settings-state/selectors', './watched-repositories-list'], function (exports, _aui, _propTypes, _react, _reactRedux, _analytics, _state, _settingsTypes, _watchedRepositoriesSettingsDialog, _actionCreators, _saveTypes, _selectors, _watchedRepositoriesList) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.WatchedRepositories = undefined;

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var analytics = _interopRequireWildcard(_analytics);

    var _state2 = _interopRequireDefault(_state);

    var _watchedRepositoriesSettingsDialog2 = _interopRequireDefault(_watchedRepositoriesSettingsDialog);

    var _watchedRepositoriesList2 = _interopRequireDefault(_watchedRepositoriesList);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var EmptyState = function EmptyState() {
        return _react2.default.createElement(
            'div',
            { className: 'watched-repositories-empty-state' },
            _react2.default.createElement('div', { className: 'image' }),
            _react2.default.createElement(
                'h3',
                null,
                _aui.I18n.getText('bitbucket.notification.repository.settings.empty.title')
            ),
            _react2.default.createElement(
                'p',
                null,
                _aui.I18n.getText('bitbucket.notification.repository.settings.empty.text')
            )
        );
    };

    var fireAnalytics = function fireAnalytics(event, repository, attributes) {
        analytics.add(event, _extends({}, attributes, {
            'repository.id': repository.id,
            'repository.project.id': repository.project.id,
            'user.id': _state2.default.getCurrentUser().id,
            source: 'watchedRepositoriesPage'
        }));
    };

    var WatchedRepositories = exports.WatchedRepositories = function (_Component) {
        _inherits(WatchedRepositories, _Component);

        function WatchedRepositories() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, WatchedRepositories);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = WatchedRepositories.__proto__ || Object.getPrototypeOf(WatchedRepositories)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                repositorySettings: {}
            }, _this.onCancelEditRepository = function () {
                fireAnalytics('notification.repository.settings.dialog.closed', _this.props.editingRepository);
                _this.props.cancelEditRepository();
            }, _this.onChangeRepositorySettings = function (setting, value) {
                _this.setState(function (state) {
                    return {
                        repositorySettings: _extends({}, _this.state.repositorySettings, _defineProperty({}, setting, value))
                    };
                });
            }, _this.onEditRepositorySettings = function (repository) {
                fireAnalytics('notification.repository.settings.dialog.opened', repository);
                _this.props.editRepository(repository);
                _this.setState({
                    repositorySettings: repository.settings
                });
            }, _this.onSaveRepositorySettings = function (settings) {
                fireAnalytics('notification.repository.settings.dialog.saved', _this.props.editingRepository, {
                    pullRequestNotificationScope: _this.state.repositorySettings.pullRequestNotificationScope,
                    pushNotificationScope: _this.state.repositorySettings.pushNotificationScope
                });
                _this.props.updateNotificationSettings(_this.props.editingRepository, _this.state.repositorySettings);
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(WatchedRepositories, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    editingRepository = _props.editingRepository,
                    repositories = _props.repositories,
                    paging = _props.paging,
                    loading = _props.loading,
                    saveState = _props.saveState,
                    unwatchRepository = _props.unwatchRepository,
                    watchRepository = _props.watchRepository,
                    loadRepositories = _props.loadRepositories;
                var repositorySettings = this.state.repositorySettings;


                if (repositories.length === 0) {
                    return _react2.default.createElement(EmptyState, null);
                }

                return _react2.default.createElement(
                    'div',
                    null,
                    editingRepository && _react2.default.createElement(_watchedRepositoriesSettingsDialog2.default, {
                        onChange: this.onChangeRepositorySettings,
                        onSave: this.onSaveRepositorySettings,
                        onClose: this.onCancelEditRepository,
                        commitsSetting: repositorySettings[_settingsTypes.SETTING_COMMITS],
                        pullRequestsSetting: repositorySettings[_settingsTypes.SETTING_PULL_REQUESTS],
                        saving: saveState[editingRepository.id] === _saveTypes.SAVE_TYPE_EDIT
                    }),
                    _react2.default.createElement(_watchedRepositoriesList2.default, {
                        paging: paging,
                        loading: loading,
                        repositories: repositories,
                        repositorySaveState: saveState,
                        onLoadMoreRepositories: loadRepositories,
                        onEditRepositorySettings: this.onEditRepositorySettings,
                        onUnwatchRepository: unwatchRepository,
                        onWatchRepository: watchRepository
                    })
                );
            }
        }]);

        return WatchedRepositories;
    }(_react.Component);

    WatchedRepositories.propTypes = {
        cancelEditRepository: _propTypes2.default.func.isRequired,
        editingRepository: _propTypes2.default.object,
        editRepository: _propTypes2.default.func.isRequired,
        loading: _propTypes2.default.bool,
        loadRepositories: _propTypes2.default.func.isRequired,
        paging: _propTypes2.default.object.isRequired,
        repositories: _propTypes2.default.arrayOf(_propTypes2.default.object).isRequired,
        saveState: _propTypes2.default.object.isRequired,
        unwatchRepository: _propTypes2.default.func.isRequired,
        updateNotificationSettings: _propTypes2.default.func.isRequired,
        watchRepository: _propTypes2.default.func.isRequired
    };


    function mapStateToProps(state) {
        return {
            repositories: (0, _selectors.repositoriesSelector)(state),
            saveState: (0, _selectors.repositorySaveStateSelector)(state),
            editingRepository: (0, _selectors.editingRepositorySelector)(state),
            paging: (0, _selectors.repositoryPagingSelector)(state),
            loading: (0, _selectors.repositoriesLoadingSelector)(state)
        };
    }

    exports.default = (0, _reactRedux.connect)(mapStateToProps, {
        editRepository: _actionCreators.editRepository,
        cancelEditRepository: _actionCreators.cancelEditRepository,
        loadRepositories: _actionCreators.loadRepositories,
        unwatchRepository: _actionCreators.unwatchRepository,
        watchRepository: _actionCreators.watchRepository,
        updateNotificationSettings: _actionCreators.updateNotificationSettings
    })(WatchedRepositories);
});