define('bitbucket-plugin-notification/internal/feature/repositories/watch-button/watch-button', ['exports', '@atlassian/aui', 'classnames', 'lodash', 'prop-types', 'react', 'react-dom', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/history', 'bitbucket/internal/util/shortcuts', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state', '../settings-types', '../watch-settings-dialog/watched-repositories-settings-dialog'], function (exports, _aui, _classnames, _lodash, _propTypes, _react, _reactDom, _analytics, _history, _shortcuts, _navbuilder, _server, _state2, _settingsTypes, _watchedRepositoriesSettingsDialog) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = exports.WatchButtonApp = exports.WatchButton = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var analytics = _interopRequireWildcard(_analytics);

    var _history2 = _interopRequireDefault(_history);

    var shortcuts = _interopRequireWildcard(_shortcuts);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    var _state3 = _interopRequireDefault(_state2);

    var _watchedRepositoriesSettingsDialog2 = _interopRequireDefault(_watchedRepositoriesSettingsDialog);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var WATCH = 'watch';

    var WatchButton = exports.WatchButton = function WatchButton(_ref) {
        var isWatching = _ref.isWatching,
            onClick = _ref.onClick;
        return _react2.default.createElement(
            'button',
            { className: 'aui-button aui-button-subtle watch-repository-button', onClick: onClick },
            _react2.default.createElement('span', {
                className: (0, _classnames2.default)('aui-icon', 'aui-icon-small', isWatching ? 'aui-iconfont-watch-filled' : 'aui-iconfont-watch')
            }),
            isWatching ? _aui.I18n.getText('bitbucket.notification.watching') : _aui.I18n.getText('bitbucket.notification.watch'),
            _react2.default.createElement('div', { className: 'watch-repository-feature-discovery-trigger' })
        );
    };

    WatchButton.propTypes = {
        onClick: _propTypes2.default.func.isRequired,
        isWatching: _propTypes2.default.bool
    };

    var fireAnalytics = function fireAnalytics(event, attributes) {
        var _state$getRepository = _state3.default.getRepository(),
            id = _state$getRepository.id,
            project = _state$getRepository.project;

        analytics.add(event, _extends({}, attributes, {
            'repository.id': id,
            'repository.project.id': project.id,
            'user.id': _state3.default.getCurrentUser().id,
            source: 'repositorySourcePage'
        }));
    };

    var WatchButtonApp = exports.WatchButtonApp = function (_React$Component) {
        _inherits(WatchButtonApp, _React$Component);

        function WatchButtonApp(props) {
            _classCallCheck(this, WatchButtonApp);

            // assumption is that settings won't change as a prop during the lifetime of this component
            var _this = _possibleConstructorReturn(this, (WatchButtonApp.__proto__ || Object.getPrototypeOf(WatchButtonApp)).call(this, props));

            _this.onWatch = function () {
                fireAnalytics('notification.repository.settings.dialog.opened');
                // copy the current settings in case of a "cancel"
                _this.setState(function (state) {
                    return {
                        editSettings: _extends({}, state.settings)
                    };
                });
            };

            _this.onClose = function () {
                fireAnalytics('notification.repository.settings.dialog.closed');
                _this.setState({
                    editSettings: null
                });
                if (location.hash === '#watch') {
                    _history2.default.replaceState(_history2.default.state(), null, location.href.split('#')[0]);
                }
            };

            _this.onSave = function () {
                // Yes this duplicates what the action creator for the watched repos list does, however it's
                // not worth bringing in Redux into this code just for handing the one async action.
                var request = _this.state.editSettings;
                var url = nav.rest('notification').addPathComponents('watch').repository(_state3.default.getRepository()).build();

                _this.setState({
                    saving: true
                });

                server.rest({
                    url: url,
                    type: 'PUT',
                    data: request
                }).done(function (response) {
                    _this.setState(function (state) {
                        var _settings;

                        return {
                            // we don't get updated isWatching value, but we can make assumptions based
                            // on the current settings
                            isWatching: _this.notificationsEnabled(state.editSettings),
                            saving: false,
                            editSettings: null,
                            settings: (_settings = {}, _defineProperty(_settings, _settingsTypes.SETTING_PULL_REQUESTS, response[_settingsTypes.SETTING_PULL_REQUESTS]), _defineProperty(_settings, _settingsTypes.SETTING_COMMITS, response[_settingsTypes.SETTING_COMMITS]), _settings)
                        };
                    });
                })
                // red dialog will show, so we just need to disable the saving state
                .fail(function () {
                    return _this.setState({ saving: false });
                });

                fireAnalytics('notification.repository.settings.dialog.saved', {
                    pullRequestNotificationScope: _this.state.editSettings[_settingsTypes.SETTING_PULL_REQUESTS],
                    pushNotificationScope: _this.state.editSettings[_settingsTypes.SETTING_COMMITS]
                });
            };

            _this.onSettingsChange = function (setting, value) {
                _this.setState(function (state) {
                    return {
                        editSettings: _extends({}, state.editSettings, _defineProperty({}, setting, value))
                    };
                });
            };

            var isWatching = props.isWatching,
                settings = props.settings;

            _this.state = {
                isWatching: isWatching,
                settings: settings,
                editSettings: (0, _lodash.includes)(window.location.hash, WATCH) ? settings : null
            };
            shortcuts.bind('requestWatchRepository', _this.onWatch);
            return _this;
        }

        _createClass(WatchButtonApp, [{
            key: 'notificationsEnabled',
            value: function notificationsEnabled(settings) {
                return settings[_settingsTypes.SETTING_PULL_REQUESTS] !== _settingsTypes.SettingPullRequestsValues.NONE || settings[_settingsTypes.SETTING_COMMITS] !== _settingsTypes.SettingCommitsValues.NONE;
            }
        }, {
            key: 'render',
            value: function render() {
                var defaultBranch = this.props.defaultBranch;
                var _state = this.state,
                    settings = _state.settings,
                    editSettings = _state.editSettings,
                    isWatching = _state.isWatching,
                    saving = _state.saving;


                return _react2.default.createElement(
                    'div',
                    null,
                    _react2.default.createElement(WatchButton, {
                        isWatching: isWatching && this.notificationsEnabled(settings),
                        onClick: this.onWatch
                    }),
                    editSettings && _react2.default.createElement(_watchedRepositoriesSettingsDialog2.default, {
                        defaultBranch: defaultBranch,
                        pullRequestsSetting: editSettings[_settingsTypes.SETTING_PULL_REQUESTS],
                        commitsSetting: editSettings[_settingsTypes.SETTING_COMMITS],
                        onSave: this.onSave,
                        onChange: this.onSettingsChange,
                        onClose: this.onClose,
                        showManageLink: true,
                        saving: saving
                    })
                );
            }
        }]);

        return WatchButtonApp;
    }(_react2.default.Component);

    function init(el) {
        try {
            var isWatching = el.dataset.isWatching === 'true';
            var settings = JSON.parse(el.dataset.settings);
            var defaultBranch = el.dataset.defaultBranch;
            _reactDom2.default.render(_react2.default.createElement(WatchButtonApp, {
                isWatching: isWatching,
                settings: settings,
                defaultBranch: defaultBranch
            }), el);
        } catch (ex) {
            console.error('Unable to parse settings from JSON!', ex);
        }
    }

    exports.init = init;
});