define('bitbucket-plugin-notification/internal/feature/repositories/watch-settings-dialog/watched-repositories-settings-dialog', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/dialog', 'bitbucket/internal/bbui/aui-react/form', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/i18n-html', 'bitbucket/util/navbuilder', '../settings-types'], function (module, exports, _aui, _propTypes, _react, _dialog, _form, _spinner, _analytics, _i18nHtml, _navbuilder, _settingsTypes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _spinner2 = _interopRequireDefault(_spinner);

    var analytics = _interopRequireWildcard(_analytics);

    var _i18nHtml2 = _interopRequireDefault(_i18nHtml);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /* global bitbucket_help_url:false */
    var WatchedRepositoriesSettingsDialog = function WatchedRepositoriesSettingsDialog(_ref) {
        var onClose = _ref.onClose,
            onSave = _ref.onSave,
            _onChange = _ref.onChange,
            commitsSetting = _ref.commitsSetting,
            defaultBranch = _ref.defaultBranch,
            pullRequestsSetting = _ref.pullRequestsSetting,
            showManageLink = _ref.showManageLink,
            saving = _ref.saving;

        var onSubmit = function onSubmit(e) {
            e.preventDefault();

            onSave();
        };

        return _react2.default.createElement(
            _dialog2.default,
            {
                id: 'watch-repository-settings-dialog',
                onClose: onClose,
                showCloseButton: false,
                titleContent: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.title'),
                footerActionContent: _react2.default.createElement(
                    'div',
                    { className: 'buttons-container' },
                    _react2.default.createElement(
                        'div',
                        { className: 'buttons' },
                        saving && _react2.default.createElement(_spinner2.default, null),
                        _react2.default.createElement(
                            'button',
                            {
                                disabled: saving,
                                className: 'aui-button aui-button-primary',
                                onClick: onSave
                            },
                            _aui.I18n.getText('bitbucket.web.button.save')
                        ),
                        _react2.default.createElement(
                            'button',
                            { className: 'aui-button aui-button-link', onClick: onClose },
                            _aui.I18n.getText('bitbucket.web.button.cancel')
                        )
                    )
                )
            },
            _react2.default.createElement(
                _i18nHtml2.default.p,
                { params: [bitbucket_help_url('bitbucket.help.notifications')] },
                _aui.I18n.getText('bitbucket.notification.settings.repository.edit.intro.html', '{0}')
            ),
            _react2.default.createElement(
                'form',
                { className: 'aui', onSubmit: onSubmit },
                _react2.default.createElement('input', { type: 'submit', hidden: true }),
                _react2.default.createElement(
                    _form.RadioGroup,
                    {
                        name: 'commits',
                        label: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits'),
                        value: commitsSetting,
                        onChange: function onChange(value) {
                            return _onChange(_settingsTypes.SETTING_COMMITS, value);
                        }
                    },
                    _react2.default.createElement(_form.Radio, {
                        id: 'commits-default',
                        autoFocus: commitsSetting === _settingsTypes.SettingCommitsValues.DEFAULT_BRANCH,
                        value: _settingsTypes.SettingCommitsValues.DEFAULT_BRANCH,
                        label: defaultBranch ? _react2.default.createElement(
                            _i18nHtml2.default.span,
                            { params: [defaultBranch] },
                            _aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits.default.html', '{0}')
                        ) : _aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits.default.nobranch')
                    }),
                    _react2.default.createElement(_form.Radio, {
                        id: 'commits-all',
                        autoFocus: commitsSetting === _settingsTypes.SettingCommitsValues.ALL,
                        value: _settingsTypes.SettingCommitsValues.ALL,
                        label: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits.all')
                    }),
                    _react2.default.createElement(_form.Radio, {
                        id: 'commits-none',
                        autoFocus: commitsSetting === _settingsTypes.SettingCommitsValues.NONE,
                        value: _settingsTypes.SettingCommitsValues.NONE,
                        label: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.commits.none')
                    })
                ),
                _react2.default.createElement(
                    _form.RadioGroup,
                    {
                        name: 'pullRequests',
                        label: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr'),
                        value: pullRequestsSetting,
                        onChange: function onChange(value) {
                            return _onChange(_settingsTypes.SETTING_PULL_REQUESTS, value);
                        }
                    },
                    _react2.default.createElement(_form.Radio, {
                        id: 'pr-state',
                        value: _settingsTypes.SettingPullRequestsValues.STATE_CHANGES,
                        label: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr.state'),
                        description: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr.state.description')
                    }),
                    _react2.default.createElement(_form.Radio, {
                        id: 'pr-all',
                        value: _settingsTypes.SettingPullRequestsValues.ALL,
                        label: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr.all')
                    }),
                    _react2.default.createElement(_form.Radio, {
                        id: 'pr-none',
                        value: _settingsTypes.SettingPullRequestsValues.NONE,
                        label: _aui.I18n.getText('bitbucket.notification.settings.repository.edit.pr.none')
                    })
                )
            ),
            showManageLink && _react2.default.createElement(
                'a',
                {
                    href: nav.pluginServlets().addPathComponents('notification', 'settings', 'repositories').build(),
                    onClick: function onClick() {
                        analytics.add('notification.repository.settings.dialog.manage.repos.clicked');
                    }
                },
                _aui.I18n.getText('bitbucket.notification.settings.repository.edit.manage')
            )
        );
    };

    WatchedRepositoriesSettingsDialog.propTypes = {
        onSave: _propTypes2.default.func.isRequired,
        onChange: _propTypes2.default.func.isRequired,
        onClose: _propTypes2.default.func.isRequired,
        commitsSetting: _propTypes2.default.oneOf(Object.keys(_settingsTypes.SettingCommitsValues)),
        pullRequestsSetting: _propTypes2.default.oneOf(Object.keys(_settingsTypes.SettingPullRequestsValues)),
        showManageLink: _propTypes2.default.bool,
        saving: _propTypes2.default.bool
    };

    exports.default = WatchedRepositoriesSettingsDialog;
    module.exports = exports['default'];
});