define('bitbucket-plugin-notification/internal/feature/repositories/watch-settings-state/action-creators', ['exports', 'bitbucket/util/navbuilder', 'bitbucket/util/server', '../settings-types', './action-types'], function (exports, _navbuilder, _server, _settingsTypes, _actionTypes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.watchRepository = exports.updateNotificationSettings = exports.unwatchRepository = exports.loadRepositories = exports.hydrate = exports.cancelEditRepository = exports.editRepository = undefined;

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function hydrate(initialData) {
        return {
            type: _actionTypes.HYDRATE,
            payload: initialData
        };
    }

    var editRepository = function editRepository(repository) {
        return function (dispatch) {
            dispatch({
                type: _actionTypes.EDIT_REPOSITORY_SETTINGS,
                payload: {
                    repository: repository
                }
            });
        };
    };

    var cancelEditRepository = function cancelEditRepository(repository) {
        return function (dispatch) {
            dispatch({
                type: _actionTypes.CANCEL_EDIT_REPOSITORY_SETTINGS
            });
        };
    };

    var updateSettings = function updateSettings(repository, newSettings, actions) {
        return function (dispatch) {
            dispatch({
                type: actions.start,
                payload: {
                    repository: repository,
                    settings: newSettings
                }
            });

            (0, _server.rest)({
                url: nav.rest('notification').addPathComponents('watch').project(repository.project).repo(repository).build(),
                type: 'PUT',
                data: newSettings
            }).done(function (response) {
                dispatch({
                    type: actions.success,
                    payload: response
                });
            }).fail(function (xhr, textStatus, _, error) {
                return dispatch({
                    type: actions.failure,
                    payload: {
                        repository: repository,
                        error: error
                    },
                    error: true
                });
            });
        };
    };

    var unwatchRepository = function unwatchRepository(repository) {
        return updateSettings(repository, _settingsTypes.UNWATCH_SETTINGS, {
            start: _actionTypes.UNWATCH_REPOSITORY,
            success: _actionTypes.UNWATCH_REPOSITORY_SUCCESS,
            failure: _actionTypes.UNWATCH_REPOSITORY_FAILURE
        });
    };

    var updateNotificationSettings = function updateNotificationSettings(repository, settings) {
        return updateSettings(repository, settings, {
            start: _actionTypes.WATCH_REPOSITORY_SETTINGS,
            success: _actionTypes.WATCH_REPOSITORY_SETTINGS_SUCCESS,
            failure: _actionTypes.WATCH_REPOSITORY_SETTINGS_FAILURE
        });
    };

    var watchRepository = function watchRepository(repository) {
        var settings = repository.previousSettings ? repository.previousSettings : _settingsTypes.DEFAULT_SETTINGS;

        return updateSettings(repository, settings, {
            start: _actionTypes.WATCH_REPOSITORY,
            success: _actionTypes.WATCH_REPOSITORY_SUCCESS,
            failure: _actionTypes.WATCH_REPOSITORY_FAILURE
        });
    };

    var loadRepositories = function loadRepositories() {
        var start = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        return function (dispatch) {
            dispatch({
                type: _actionTypes.LOAD_REPOSITORIES
            });

            (0, _server.rest)({
                url: nav.rest('notification').addPathComponents('watch', 'repos').withParams({
                    start: start,
                    avatarSize: 64,
                    pullRequestNotificationScopes: [_settingsTypes.SettingPullRequestsValues.ALL, _settingsTypes.SettingPullRequestsValues.STATE_CHANGES],
                    pushNotificationScopes: [_settingsTypes.SettingCommitsValues.ALL, _settingsTypes.SettingCommitsValues.DEFAULT_BRANCH]
                }).build(),
                type: 'GET'
            }).done(function (response) {
                dispatch({
                    type: _actionTypes.LOAD_REPOSITORIES_SUCCESS,
                    payload: response
                });
            }).fail(function (xhr, textStatus, _, error) {
                dispatch({
                    type: _actionTypes.LOAD_REPOSITORIES_FAILURE,
                    error: true,
                    payload: error
                });
            });
        };
    };

    exports.editRepository = editRepository;
    exports.cancelEditRepository = cancelEditRepository;
    exports.hydrate = hydrate;
    exports.loadRepositories = loadRepositories;
    exports.unwatchRepository = unwatchRepository;
    exports.updateNotificationSettings = updateNotificationSettings;
    exports.watchRepository = watchRepository;
});