define('bitbucket-plugin-notification/internal/feature/repositories/watch-settings-state/entities', ['module', 'exports', 'icepick', 'lodash', 'redux', '../settings-types', './action-types'], function (module, exports, _icepick, _lodash, _redux, _settingsTypes, _actionTypes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var entityFromPayload = function entityFromPayload(payload) {
        return _extends({}, payload.repository, {
            defaultBranch: (0, _lodash.get)(payload, 'defaultBranch.displayId'),
            settings: (0, _lodash.pick)(payload, [_settingsTypes.SETTING_PULL_REQUESTS, _settingsTypes.SETTING_COMMITS])
        });
    };

    var entitiesFromPayload = function entitiesFromPayload(page) {
        return page.values.reduce(function (memo, value) {
            var repository = value.repository;

            memo[repository.id] = entityFromPayload(value);

            return memo;
        }, {});
    };

    var repositoryEntitiesReducer = function repositoryEntitiesReducer() {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var action = arguments[1];

        if (action.type === _actionTypes.HYDRATE) {
            return entitiesFromPayload(action.payload);
        } else if (action.type === _actionTypes.WATCH_REPOSITORY_SETTINGS_SUCCESS || action.type === _actionTypes.UNWATCH_REPOSITORY_SUCCESS || action.type === _actionTypes.WATCH_REPOSITORY_SUCCESS) {
            var repository = action.payload.repository;


            return (0, _icepick.merge)(state, _defineProperty({}, repository.id, _extends({}, entityFromPayload(action.payload), {
                previousSettings: state[repository.id].settings
            })));
        } else if (action.type === _actionTypes.LOAD_REPOSITORIES_SUCCESS) {
            return (0, _icepick.merge)(state, entitiesFromPayload(action.payload));
        }

        return state;
    };

    exports.default = (0, _redux.combineReducers)({
        repositories: repositoryEntitiesReducer
    });
    module.exports = exports['default'];
});