define('bitbucket-plugin-notification/internal/feature/repositories/watch-settings-state/paging', ['module', 'exports', 'icepick', 'lodash', 'redux', './action-types'], function (module, exports, _icepick, _lodash, _redux, _actionTypes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var repositoryPagingReducer = function repositoryPagingReducer() {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { ids: [], isLastPage: true };
        var action = arguments[1];

        if (action.type === _actionTypes.HYDRATE) {
            var page = action.payload;
            var values = void 0;

            // if the only page is the last page sort by project / repo
            if (page.isLastPage) {
                values = (0, _icepick.sort)(page.values, function (a, b) {
                    var sortString = function sortString(repo) {
                        return repo.project.name + '/' + repo.name;
                    };

                    return sortString(a.repository).localeCompare(sortString(b.repository));
                });
            } else {
                values = page.values;
            }

            return _extends({
                ids: values.map(function (value) {
                    return value.repository.id;
                })
            }, (0, _lodash.omit)(action.payload, 'values'));
        } else if (action.type === _actionTypes.UNWATCH_REPOSITORY_SUCCESS && !state.isLastPage) {
            // on unwatch the repository will no longer be part of the page,
            // so the next page will start at one less
            return (0, _icepick.set)(state, 'nextPageStart', state.nextPageStart - 1);
        } else if (action.type === _actionTypes.LOAD_REPOSITORIES_SUCCESS) {
            return (0, _icepick.merge)(state, _extends({
                ids: state.ids.concat(action.payload.values.map(function (value) {
                    return value.repository.id;
                }))
            }, (0, _lodash.omit)(action.payload, 'values')));
        }

        return state;
    };

    exports.default = (0, _redux.combineReducers)({
        repositories: repositoryPagingReducer
    });
    module.exports = exports['default'];
});