define('bitbucket-plugin-notification/internal/feature/repositories/watch-settings-state/selectors', ['exports', 'reselect'], function (exports, _reselect) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.repositorySaveStateSelector = exports.repositoriesSelector = exports.repositoriesLoadingSelector = exports.repositoryPagingSelector = exports.editingRepositorySelector = undefined;


    var repositories = function repositories(state) {
        return state.entities.repositories;
    };
    var repositoryIds = function repositoryIds(state) {
        return state.paging.repositories.ids;
    };
    var repositorySaveStateSelector = function repositorySaveStateSelector(state) {
        return state.ui.repositorySaveState;
    };
    var editingRepositorySelector = function editingRepositorySelector(state) {
        return state.ui.editingRepository;
    };
    var repositoryPagingSelector = function repositoryPagingSelector(state) {
        return state.paging.repositories;
    };
    var repositoriesLoadingSelector = function repositoriesLoadingSelector(state) {
        return state.ui.loadingRepositories;
    };

    var repositoriesSelector = (0, _reselect.createSelector)([repositoryIds, repositories], function (ids, repositories) {
        return ids.map(function (id) {
            return repositories[id];
        });
    });

    exports.editingRepositorySelector = editingRepositorySelector;
    exports.repositoryPagingSelector = repositoryPagingSelector;
    exports.repositoriesLoadingSelector = repositoriesLoadingSelector;
    exports.repositoriesSelector = repositoriesSelector;
    exports.repositorySaveStateSelector = repositorySaveStateSelector;
});