define('bitbucket-plugin-notification/internal/feature/repositories/watch-settings-state/ui', ['module', 'exports', 'icepick', 'redux', './action-types', './save-types'], function (module, exports, _icepick, _redux, _actionTypes, _saveTypes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var repositorySaveStateReducer = function repositorySaveStateReducer() {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var action = arguments[1];

        // the assumption for this reducer is that you can either be editing repo settings, or unwatching a repo
        var saveType = void 0;

        if (action.type === _actionTypes.UNWATCH_REPOSITORY) {
            saveType = _saveTypes.SAVE_TYPE_UNWATCH;
        } else if (action.type === _actionTypes.WATCH_REPOSITORY) {
            saveType = _saveTypes.SAVE_TYPE_WATCH;
        } else if (action.type === _actionTypes.WATCH_REPOSITORY_SETTINGS) {
            saveType = _saveTypes.SAVE_TYPE_EDIT;
        }

        if (saveType) {
            return (0, _icepick.set)(state, action.payload.repository.id, saveType);
        }

        if (action.type === _actionTypes.UNWATCH_REPOSITORY_FAILURE || action.type === _actionTypes.UNWATCH_REPOSITORY_SUCCESS || action.type === _actionTypes.WATCH_REPOSITORY_SETTINGS_SUCCESS || action.type === _actionTypes.WATCH_REPOSITORY_SETTINGS_FAILURE || action.type === _actionTypes.WATCH_REPOSITORY_SUCCESS || action.type === _actionTypes.WATCH_REPOSITORY_FAILURE) {
            return (0, _icepick.unset)(state, action.payload.repository.id);
        }

        return state;
    };

    var editingRepositoryReducer = function editingRepositoryReducer() {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
        var action = arguments[1];

        if (action.type === _actionTypes.EDIT_REPOSITORY_SETTINGS) {
            return action.payload.repository;
        } else if (action.type === _actionTypes.CANCEL_EDIT_REPOSITORY_SETTINGS || action.type === _actionTypes.WATCH_REPOSITORY_SETTINGS_SUCCESS) {
            return null;
        }

        return state;
    };

    var loadingRepositoriesReducer = function loadingRepositoriesReducer() {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
        var action = arguments[1];

        if (action.type === _actionTypes.LOAD_REPOSITORIES) {
            return true;
        } else if (action.type === _actionTypes.LOAD_REPOSITORIES_SUCCESS || action.type === _actionTypes.LOAD_REPOSITORIES_FAILURE) {
            return false;
        }

        return state;
    };

    exports.default = (0, _redux.combineReducers)({
        editingRepository: editingRepositoryReducer,
        repositorySaveState: repositorySaveStateReducer,
        loadingRepositories: loadingRepositoriesReducer
    });
    module.exports = exports['default'];
});