function deleteConsumerInformation(title, message, cancel) {
    if (!cancel) {
        cancel = function() {};
    }
    var popup = new AJS.Dialog({
        width: 450,
        height: 180,
        id: "confirm-dialog",
        onCancel: cancel
    });

    popup.addHeader(title);
    popup.addPanel(title);
    popup.getCurrentPanel().html(message);

    popup.addButton(AJS.I18n.getText('applinks.delete'), function() {
        AJS.$('#oauth-incoming-enabled').val('false');
        popup.remove();
        AJS.$('#add-consumer-manually').submit();
    }, "confirm");
    popup.addButton(AJS.I18n.getText('applinks.cancel'), function() {
        popup.remove();
    }, 'cancel');

    popup.show();
    popup.popup.element.addClass('aui-dialog-content-ready');
    return false;
}

function deleteServiceProviderInformation(title, message, confirm, cancel) {
    if (!cancel) {
        cancel = function() {};
    }
    var popup = new AJS.Dialog({
        width: 450,
        height: 180,
        id: "confirm-dialog",
        onCancel: cancel
    });

    popup.addHeader(title);
    popup.addPanel(title);
    popup.getCurrentPanel().html(message);

    popup.addButton("delete", function() {
        AJS.$("#oauth-outgoing-enabled").val("false");
        popup.remove();
        AJS.$("#add-serviceprovider").submit();
    }, "confirm");
    popup.addButton("cancel", function() {
        popup.remove();
    }, "cancel");

    popup.show();
    popup.popup.element.addClass("aui-dialog-content-ready");
    return false;
}


function enableDisableOAuthInRemoteApp(url)
{
    var enabled = AJS.$('#oauth-incoming-enabled').val();
    var remoteURL = url.replace(/ENABLE_DISABLE_OAUTH_PARAM/g, enabled);
    window.location = remoteURL;
    return false;
}

function enableDisableTwoLeggedOAuthInRemoteApp(url)
{
    var enabled = AJS.$('#oauth-incoming-enabled').val();
    var outgoing2LOEnabled = AJS.$('#outgoing-two-lo-enabled').is(":checked");
    var existingOutgoing2LOState = "true" == AJS.$('#existing-outgoing-2lo-state').val();
    var outgoing2LOiEnabled = AJS.$('#outgoing-two-loi-enabled').is(":checked");
    var existingOutgoing2LOiState = "true" == AJS.$('#existing-outgoing-2loi-state').val();

    var remoteURL;
    remoteURL = url.replace(/ENABLE_DISABLE_OAUTH_PARAM/g, enabled == 'false');
    remoteURL = remoteURL.replace(/ENABLE_DISABLE_OUTGOING_TWO_LEGGED_OAUTH_PARAM/g, outgoing2LOEnabled);
    remoteURL = remoteURL.replace(/ENABLE_DISABLE_OUTGOING_TWO_LEGGED_I_OAUTH_PARAM/g, outgoing2LOiEnabled);

    if(outgoing2LOEnabled != existingOutgoing2LOState
        || outgoing2LOiEnabled != existingOutgoing2LOiState) {
        window.location = remoteURL;
    }

    return false;
}

const attachAppLinkEventHandlers = () => {
    // Utility to attach a click handler for delete buttons
    const attachDeleteHandler = (selector, handler) => {
        const element = document.querySelector(selector);

        if (!element) {
            console.warn("attachDeleteHandler: No element found for selector: " + selector);
            return;
        }

        document.querySelector(selector).addEventListener("click", function () {
            const title = this.dataset ? this.dataset.title : null;
            const message = this.dataset ? this.dataset.message: null;
            handler(
                title,
                message
            );
        });
    }

    // Utility to attach submit handler for a form with a remoteUrl dataset
    const attachFormSubmitHandler = (formId, handlerFn) => {
        const form = document.getElementById(formId);
        const remoteUrl = (form && form.dataset) ? form.dataset.remoteUrl : null;
        if (form && remoteUrl) {
            form.addEventListener("submit", (event) => {
                if (!handlerFn(remoteUrl)) {
                    event.preventDefault();
                }
            });
        }
    }

    // Attach delete handlers for the incoming_nonapplinks
    attachDeleteHandler(
        "#add-consumer-manually .buttons-container #delete",
        deleteConsumerInformation
    );

    // Attach delete handlers for the outbound_nonapplinks
    attachDeleteHandler(
        "#add-serviceprovider .buttons-container #delete",
        deleteServiceProviderInformation
    );

    // Attach form submit handlers for incoming_applinks
    attachFormSubmitHandler("incoming-oauth-applink-form", enableDisableOAuthInRemoteApp);
    attachFormSubmitHandler("two-legged-oauth-config-form", enableDisableTwoLeggedOAuthInRemoteApp);
}

const onDomReady = (callback) => {
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', callback);
    } else {
        // DOM is already ready
        callback();
    }
}
// Attach handlers when the DOM is ready
onDomReady(attachAppLinkEventHandlers);
