define('bitbucket-plugin-xcode/internal/xcode-clone/xcode-clone', [
    '@atlassian/aui',
    'jquery',
    'bitbucket/util/events',
    'bitbucket/util/navbuilder',
    'bitbucket/util/state',
    'bitbucket/internal/util/analytics',
    'exports',
], function (AJS, $, events, nav, pageState, analytics, exports) {
    var updateXcodeCloneUrl = function (cloneProtocol, cloneUrl) {
        $('#xcode-clone-button').attr('href', 'xcode://clone?repo=' + encodeURIComponent(cloneUrl));
    };

    exports.onReady = function () {
        events.on(
            'bitbucket.internal.DO_NOT_USE.feature.repository.clone.mirror.changed',
            updateXcodeCloneUrl
        );
        events.on(
            'bitbucket.internal.DO_NOT_USE.feature.repository.clone.protocol.changed',
            updateXcodeCloneUrl
        );
        events.on(
            'bitbucket.internal.DO_NOT_USE.feature.repository.clone.protocol.initial',
            updateXcodeCloneUrl
        );

        $(document).on('click', '#xcode-clone-button', function () {
            analytics.add('xcode.clonebutton.clicked', {
                'project.id': pageState.getProject().id,
                'repository.id': pageState.getRepository().id,
            });
        });
    };
});
