(function () {
    var contextPath =
        typeof AJS.contextPath === "function" ? AJS.contextPath() : "";

    function onSuccess() {
        AJS.messages.generic("#analytics-enable-form", {
            body: AJS.I18n.getText("analytics.configuration.enable.success"),
            id: "config-updated",
            insert: "append",
            closeable: false,
            shadowed: true,
            fadeout: true
        });
    }

    function onError() {
        AJS.messages.error("#analytics-enable-form", {
            body: AJS.I18n.getText("analytics.configuration.enable.error"),
            id: "config-update-failed",
            insert: "append",
            closeable: false,
            shadowed: true,
            fadeout: true
        });
    }

    AJS.toInit(function ($) {
        let $spinner = $(".buttons .loading");
        let $form = $("#analytics-enable-form");
        $form.on("submit", function (e) {
            e.preventDefault();
            let analyticsEnabled = $form.find('#enable-analytics').is(':checked');
            let analyticsOption = $form.find('input[name="analyticsOption"]:checked').val();
            let bodyContent = $form.find('#enable-analytics').length > 0 ? {analyticsEnabled} : {analyticsOption};
            let hideSpinner = () => $spinner.addClass("hidden");
            $spinner.removeClass("hidden");
            fetch(contextPath + "/rest/analytics/1.0/config/enable", {
                method: "PUT",
                headers: {
                    "Content-Type": "application/json",
                },
                cache: "no-cache",
                credentials: "same-origin",
                body: JSON.stringify(bodyContent),
            })
                .then(() => {
                    onSuccess();
                    hideSpinner();
                }, () => {
                    onError();
                    hideSpinner();
                });
        });

        $("#test-data-sharing-button").click(function() {
            const button = this;
            if (button.isBusy()) {
                return;
            }

            const $testDataSharingResult = $(".test-data-sharing-result");
            const successMessageHtml = `
<span class="aui-icon aui-iconfont-check-circle-filled success-icon"></span>
<span class="test-data-sharing-result-title">
    ${AJS.I18n.getText("analytics.configuration.test.data.sharing.result.success")}
</span>`;
            const getFailedMessageHtml = (errorMessage = AJS.I18n.getText("analytics.configuration.test.data.sharing.result.failed.generic")) => `
<span class="aui-icon aui-iconfont-error failed-icon"></span>
<span class="test-data-sharing-result-title">
    ${AJS.I18n.getText("analytics.configuration.test.data.sharing.result.failed")}
</span>
${errorMessage}
`;

            button.busy();
            $testDataSharingResult.empty();

            fetch(`${contextPath}/rest/analytics/1.0/config/connectivity-check`, {
                method: "GET",
            }).then(async (response) => {
                if (response.ok) {
                    $testDataSharingResult.html(successMessageHtml);
                    return;
                }

                const responseJson = await response.json();
                if (typeof responseJson.errorMessage === 'string' && responseJson.errorMessage.length > 0) {
                    $testDataSharingResult.html(getFailedMessageHtml(responseJson.errorMessage));
                    return;
                }

                $testDataSharingResult.html(getFailedMessageHtml());
            }).catch(() => {
                $testDataSharingResult.html(getFailedMessageHtml());
            }).finally(() => {
                button.idle();
            });
        })
    });
})();
