(function () {
    /**
     * Provides a way to publish events asynchronously, without requiring AJS.Events to have loaded.
     * Users of this property must conditionally initialise it to an empty array. Objects pushed
     * must have a name property, and optionally a properties property of other data to send.
     * @example
     * AJS.EventQueue = AJS.EventQueue || [];
     * AJS.EventQueue.push({name: 'eventName', properties: {some: 'data', more: true, hits: 20}});
     */
    AJS.EventQueue = AJS.EventQueue || [];

    const arrayPush = Array.prototype.push;
    AJS.EventQueue.push = function (obj) {
        obj.time = new Date().getTime();
        arrayPush.call(AJS.EventQueue, obj);
    };

    /**
     * @deprecated since v3.39, please trigger as normal and use whitelisting to denote privacy policy safe events
     */
    AJS.Analytics = {
        triggerPrivacyPolicySafeEvent: function (name, properties) {
            AJS.log('WARN: \'triggerPrivacyPolicySafeEvent\' has been deprecated');
            AJS.EventQueue.push({ name: name, properties: properties });
        }
    };
}());
