define('atlassian/analytics/page-visibility', function () {
    var hasBrowserSupport = (document.hidden !== undefined);

    /**
     * A partial wrapper for the Page Visibility API
     * @export atlassian/analytics/page-visibility
     */
    var wrapper = {

        /** Is the API supported by the browser? */
        supported: hasBrowserSupport,

        /**
         * A proxy for `document.hidden`.
         * Defaults to false if the API is not supported by the browser
         * @returns {boolean}
         */
        isHidden: function () {
            return hasBrowserSupport ? document.hidden : false;
        }
    };

    return wrapper;
});
