'use strict';

/* globals bitbucket_help_url:false */
define('bitbucket-plugin-default-reviewers/internal/feature/default-reviewers/default-reviewers', ['@atlassian/aui', 'chaperone', 'jquery', 'lodash', 'bitbucket/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state', 'exports'], function (AJS, Chaperone, $, _, events, nav, server, pageState, exports) {
    'use strict';

    var $reviewerEl;
    var defaultReviewers;

    exports.init = function () {
        if (!pageState.getCurrentUser()) {
            // Anonymous users can't create pull requests, so we don't need to initialize.
            return;
        }
        $reviewerEl = $('#reviewers');

        events.on('bitbucket.internal.DO_NOT_USE.feature.compare.form.state', function (formState) {
            if (formState.newForm === 'pullRequest') {
                refreshDefaultReviewers();
            }
        });

        var sourceBranch = pageState.getSourceBranch();
        var targetBranch = pageState.getTargetBranch();

        if (sourceBranch && targetBranch && sourceBranch.type.id === 'branch' && targetBranch.type.id === 'branch') {
            refreshDefaultReviewers();
        }
    };

    function setupFeatureDiscovery() {
        var metaEl = document.getElementById('default-reviewers-feature-discovery-meta');
        var isRepoAdmin = metaEl && metaEl.dataset.featureDiscoveryLevel === 'repo-admin';
        var content = AJS.I18n.getText('bitbucket.defaultreviewers.discovery.content');
        // for regular users also add the CTA to contact a repo admin to change the setting
        var speakToAdminCTA = AJS.I18n.getText('bitbucket.defaultreviewers.discovery.content.ask.for.change');
        var adminLink = {};

        if (isRepoAdmin) {
            // for admins add a link to the settings and remove the CTA to contact a repo admin
            adminLink = {
                url: nav.pluginServlets().path('default-reviewers').repository(pageState.getRepository()).build(),
                urlText: AJS.I18n.getText('bitbucket.defaultreviewers.discovery.repo-admin.link.text')
            };
            speakToAdminCTA = '';
        }

        Chaperone.registerFeature('default-reviewers', [{
            id: 'default-reviewers-discovery',
            selector: '#s2id_reviewers',
            alignment: 'left middle',
            title: AJS.I18n.getText('bitbucket.defaultreviewers.discovery.user.title'),
            persistent: false,
            content: bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.defaultReviewers.featureDiscoveryContent({
                content: content + ' ' + speakToAdminCTA,
                url: adminLink.url,
                urlText: adminLink.urlText
            }),
            close: {
                text: AJS.I18n.getText('bitbucket.web.got.it')
            },
            moreInfo: {
                href: bitbucket_help_url('bitbucket.help.defaultreviewers.learn.more'),
                text: AJS.I18n.getText('bitbucket.defaultreviewers.learn.more'),
                extraAttributes: {
                    target: '_blank'
                }
            },
            width: 340,
            once: true
        }]);
    }

    function refreshDefaultReviewers() {
        var ERROR_ID = 'default-reviewers-error';
        $('#' + ERROR_ID).remove();

        var sourceRepo = pageState.getSourceBranch().repository.id;
        var sourceBranch = pageState.getSourceBranch().id;

        var targetRepo = pageState.getTargetBranch().repository.id;
        var targetBranch = pageState.getTargetBranch().id;

        if (sourceRepo && sourceBranch && targetRepo && targetBranch) {
            server.rest({
                url: nav.rest('default-reviewers', 'latest').repository(pageState.getRepository()).addPathComponents('reviewers').withParams({ avatarSize: 32 }).build(),
                contentType: 'application/json',
                type: 'GET',
                data: {
                    sourceRepoId: sourceRepo,
                    sourceRefId: sourceBranch,
                    targetRepoId: targetRepo,
                    targetRefId: targetBranch
                }
            }).done(function (data) {
                var currentUserName = pageState.getCurrentUser().name;

                // Get a list of current reviewers, removing the old default reviewers
                var reviewers = $reviewerEl.data('select2').data().filter(function (el) {
                    return defaultReviewers ? !_.includes(defaultReviewers, el) : true;
                }).sort(function (el1, el2) {
                    if (el1.name < el2.name) {
                        return 1;
                    }
                    if (el1.name > el2.name) {
                        return -1;
                    }

                    return 0;
                });

                // Get a list of the new default reviewers and add them to the reviewer list
                defaultReviewers = data && data.filter(function (el) {
                    return el.name !== currentUserName;
                }).map(function (el) {
                    return {
                        id: el.name,
                        item: el
                    };
                });
                defaultReviewers.forEach(function (el) {
                    if (!_.includes(reviewers, el)) {
                        reviewers.push(el);
                    }
                });

                // Add all the reviewers
                $reviewerEl.data('select2').data(reviewers);

                if (defaultReviewers && defaultReviewers.length) {
                    setupFeatureDiscovery();
                }
            }).fail(function () {
                // if anything failed, show an error message
                $reviewerEl.after(bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.defaultReviewers.errorMessage({
                    id: ERROR_ID,
                    message: AJS.I18n.getText('bitbucket.defaultreviewers.pullRequest.create.fetch.error')
                }));
            });
        }
    }
});