'use strict';

define('bitbucket-plugin-default-reviewers/internal/feature/default-reviewers/table/default-reviewers-table', ['@atlassian/backbone-brace', 'jquery', 'bitbucket-plugin-default-reviewers/internal/model/default-reviewers/default-reviewer-set-collection'], function (Brace, $, DefaultReviewerSetCollection) {
    'use strict';

    var DefaultReviewersTableView = Brace.View.extend({
        namedAttributes: {
            collection: DefaultReviewerSetCollection
        },
        template: bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.table.defaultReviewersTable.defaultReviewersTable,
        /**
         * @param {Object} options
         * @param {DefaultReviewersSetCollection} options.defaultReviewers
         * @param {ScopeType} options.scopeType
         * @param {string} options.projectSettingsUrl
         * @param {HTMLElement} options.el
         */
        initialize: function initialize(options) {
            this.options = options || {};

            this.collection = this.options.defaultReviewers;
            this._scopeType = this.options.scopeType;
            this._projectSettingsUrl = this.options.projectSettingsUrl;

            this.render();
            this.listenTo(this.collection, 'add', this.render);
            this.listenTo(this.collection, 'remove', this.render);
            this.listenTo(this.collection, 'change', this.editRow);
        },
        destroy: function destroy() {
            this.stopListening(this.collection);
            this.$el.removeData().unbind();
            this.$el.empty();
            this.remove();
        },
        render: function render(model, collection, opts) {
            if (this.collection.length === 0) {
                this.$el.empty();

                return this;
            }
            if (!model && this.collection.length > 0 || // initial render
            model && this.collection.length === 1 && opts.add === true // first addition requires the table to be rendered
            ) {
                    this.$el.html(this.template({
                        scopeType: this._scopeType,
                        projectSettingsUrl: this._projectSettingsUrl,
                        defaultReviewers: this.collection.toJSON()
                    }));

                    return this;
                }
            if (opts.add === true) {
                this.addRow(model);

                return this;
            }
            if (opts.index != null) {
                // delete has "index" of the deleted item. yey for inconsistent ways of doing shit.
                this.deleteRow(model);
            }

            return this;
        }
    });

    /**
     * Adds a row to the table view.
     * @param {DefaultReviewerSet} defaultReviewerSet
     */
    DefaultReviewersTableView.prototype.addRow = function (defaultReviewerSet) {
        this.$('tbody').append(bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.table.defaultReviewersTable.defaultReviewerRow({
            scopeType: this._scopeType,
            projectSettingsUrl: this._projectSettingsUrl,
            defaultReviewerSet: defaultReviewerSet.toJSON()
        }));
    };

    /**
     * Updates a the table row containing the defaultReviewerSet
     * @param {DefaultReviewerSet} defaultReviewerSet
     * @this {DefaultReviewersTableView}
     */
    DefaultReviewersTableView.prototype.editRow = function (defaultReviewerSet) {
        var $row = this.$el.find('tr[data-id="' + defaultReviewerSet.getId() + '"]');
        $row.replaceWith(bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.table.defaultReviewersTable.defaultReviewerRow({
            scopeType: this._scopeType,
            projectSettingsUrl: this._projectSettingsUrl,
            defaultReviewerSet: defaultReviewerSet.toJSON()
        }));
    };

    /**
     * Deletes the table row containing the refRestriction
     * @param {DefaultReviewerSet} defaultReviewerSet
     */
    DefaultReviewersTableView.prototype.deleteRow = function (defaultReviewerSet) {
        this.$el.find('tr[data-id="' + defaultReviewerSet.getId() + '"]').remove();
    };

    /**
     * Shows a spinner on the specified row
     * @param {jQuery} $row
     */
    DefaultReviewersTableView.showRowSpinner = function ($row) {
        $row.find('.spinner').addClass('show').spin();
    };

    /**
     * Hides a spinner on the specified row
     * @param {jQuery} $row
     */
    DefaultReviewersTableView.hideRowSpinner = function ($row) {
        $row.find('.spinner').removeClass('show').spinStop();
    };

    /**
     * Show the action buttons on the specified row
     * @param {jQuery} $row
     */
    DefaultReviewersTableView.showActionButtons = function ($row) {
        $row.find('.actions-cell a').show();
    };

    /**
     * Hide the action buttons on the specified row to avoid user interaction while an action is in progress
     * @param {jQuery} $row
     */
    DefaultReviewersTableView.hideActionButtons = function ($row) {
        $row.find('.actions-cell a').hide();
    };

    return DefaultReviewersTableView;
});