'use strict';

define('bitbucket-plugin-default-reviewers/internal/model/default-reviewers/default-reviewer-set-collection', ['@atlassian/backbone-brace', 'bitbucket-plugin-default-reviewers/internal/model/default-reviewers/default-reviewer-set'], function (Brace, DefaultReviewerSet) {
    'use strict';

    /**
     * @param {number} id
     * @param {Object} details
     * @this {DefaultReviewerSetCollection}
     */

    function setDefaultReviewerDetails(details, id) {
        var defaultReviewerSet = this.get(id);

        if (defaultReviewerSet) {
            defaultReviewerSet.setDetails(details);
        }
    }

    var DefaultReviewerSetCollection = Brace.Collection.extend({
        model: DefaultReviewerSet,

        setDetails: function setDetails(detailsById) {
            if (detailsById) {
                detailsById.forEach(setDefaultReviewerDetails.bind(this));
            }
        }
    });

    return DefaultReviewerSetCollection;
});