'use strict';

define('bitbucket-plugin-default-reviewers/internal/model/default-reviewers/ref-matcher', ['@atlassian/backbone-brace', 'jquery', 'bitbucket-plugin-default-reviewers/internal/model/default-reviewers/ref-matcher-type', 'bitbucket-plugin-default-reviewers/internal/model/default-reviewers/supported-matcher-types'], function (Brace, $, RefMatcherType, SupportedMatcherTypes) {
    'use strict';

    return Brace.Model.extend({
        namedAttributes: {
            id: 'string',
            displayId: 'string',
            active: 'boolean',
            type: RefMatcherType
        },
        setDetails: function setDetails(details) {
            return this.set($.extend(true, this.toJSON(), details));
        },
        equals: function equals(that) {
            return this.id === that.id && this.getType().getId().toUpperCase() === that.getType().getId().toUpperCase();
        },
        branch: function branch(ref) {
            ref = ref || {};

            return this.set({
                id: ref.id || '',
                displayId: ref.displayId || '',
                type: new RefMatcherType().setDetails({
                    id: SupportedMatcherTypes.BRANCH
                })
            });
        },
        pattern: function pattern(_pattern) {
            return this.set({
                id: _pattern,
                displayId: _pattern,
                type: new RefMatcherType().setDetails({
                    id: SupportedMatcherTypes.PATTERN
                })
            });
        },
        model: function model(id, isBranch) {
            return this.set({
                id: id,
                displayId: id,
                type: new RefMatcherType().setDetails({
                    id: isBranch ? SupportedMatcherTypes.MODEL_BRANCH : SupportedMatcherTypes.MODEL_CATEGORY
                })
            });
        },
        any: function any() {
            return this.set({
                id: 'any',
                displayId: 'Any branch',
                type: new RefMatcherType().setDetails({
                    id: SupportedMatcherTypes.ANY_REF
                })
            });
        }
    });
});