'use strict';

define('bitbucket-plugin-default-reviewers/internal/page/default-reviewers/default-reviewers-page', ['@atlassian/aui', '@atlassian/backbone-brace', 'jquery', 'lodash', 'bitbucket/util/navbuilder', 'bitbucket/util/state', 'bitbucket/util/server', 'bitbucket/internal/enums', 'bitbucket/internal/util/scope-type', 'bitbucket-plugin-default-reviewers/internal/feature/default-reviewers/dialog/default-reviewers-dialog', 'bitbucket-plugin-default-reviewers/internal/feature/default-reviewers/table/default-reviewers-table', 'bitbucket-plugin-default-reviewers/internal/model/default-reviewers/default-reviewer-set-collection', 'bitbucket-plugin-default-reviewers/internal/model/default-reviewers/supported-matcher-types', 'exports'], function (AJS, Brace, $, _, nav, pageState, server, _ref, scopeTypeUtil, DefaultReviewersDialog, DefaultReviewersTableView, DefaultReviewerSetCollection, SupportedMatcherTypes, exports) {
    var ScopeType = _ref.ScopeType;

    function maybeRender() {
        // if the collection length has changed and it's 0 or 1, then we want to render
        // once the table has been rendered there is no need to keep re-rendering
        if (this.collection.length !== this.cachedLength && this.collection.length <= 1) {
            this.render();
        }
        this.cachedLength = this.collection.length;
    }

    var DefaultReviewersHeaderView = Brace.View.extend({
        namedAttributes: {
            collection: DefaultReviewerSetCollection
        },
        initialize: function initialize(options) {
            this.options = options || {};

            this.collection = this.options.collection;
            this.cachedLength = this.collection.length;
            this.collection.on('add remove', this.maybeRender.bind(this));
            this.render();
        },
        template: bitbucketPluginDefaultReviewers.internal.page.defaultReviewers.defaultReviewersPage.pageHeader,
        maybeRender: maybeRender,
        render: function render() {
            this.$el.html(this.template({
                renderDetailedHeader: this.collection.length > 0
            }));
        }
    });

    // This is a "dumb" parent page view that displays the header view and works out
    // if it should display the table or the splash page.
    var DefaultReviewersPageView = Brace.View.extend({
        namedAttributes: {
            collection: DefaultReviewerSetCollection
        },
        initialize: function initialize(options) {
            _.bindAll(this, _.functions(this.constructor.prototype));
            this.options = options || {};
            this.collection = this.options.defaultReviewers;
            this.cachedLength = this.collection.length;

            new DefaultReviewersHeaderView({
                el: this.options.headerViewEl,
                collection: this.collection
            });

            new DefaultReviewersTableView({
                defaultReviewers: this.collection,
                el: this.options.tableViewEl,
                scopeType: this.options.scopeType,
                projectSettingsUrl: this.options.projectSettingsUrl
            });

            this.collection.on('add remove', this.maybeRender.bind(this));
            this.render();
        },
        template: bitbucketPluginDefaultReviewers.internal.page.defaultReviewers.defaultReviewersPage.emptySplash,
        maybeRender: maybeRender,
        render: function render() {
            if (this.collection.length === 0) {
                this.$el.html(this.template());
            } else {
                this.$el.empty();
            }
        }
    });

    /**
     * @param {Object} options
     * @param {Object} options.defaultReviewersJSON
     * @param {string?} options.defaultBranch
     * @param {string} options.scopeType
     * @param {string?} options.projectSettingsUrl
     */
    function onReady(options) {
        var tableViewEl = document.getElementById('default-reviewers-content');
        var $content = $(tableViewEl);
        var $doc = $(document);
        var defaultReviewers = new DefaultReviewerSetCollection(options.defaultReviewersJSON);
        var DELETE_DIALOG_ID = 'default-reviewer-delete-confirm-dialog';

        new DefaultReviewersPageView({
            el: document.getElementById('default-reviewers-splash'),
            tableViewEl: tableViewEl,
            headerViewEl: document.getElementById('default-reviewers-header'),
            defaultReviewers: defaultReviewers,
            scopeType: options.scopeType,
            projectSettingsUrl: options.projectSettingsUrl
        });

        $content.on('click', '#default-reviewers-table .delete-button', rowDeleteClicked);
        $content.on('click', '#default-reviewers-table .edit-button', rowEditClicked);
        $doc.on('click', '#add-default-reviewer-button, #add-default-reviewer-button-empty-state', addDefaultReviewerClicked);
        $doc.on('click', '.delete-cancel-button', deleteDialogCancelClicked);
        $doc.on('click', '.delete-confirm-button', deleteDialogConfirmClicked);

        function addDefaultReviewerClicked(e) {
            e.preventDefault();
            var dialog = new DefaultReviewersDialog({
                scopeType: options.scopeType,
                dialogOptions: {
                    callback: saveToCollection,
                    defaultBranch: options.defaultBranch
                }
            });
            dialog.show();
        }

        function saveToCollection(defaultReviewerSetJSON) {
            defaultReviewers.add(defaultReviewerSetJSON, { merge: true });
            populateBranchModelBranches(options.scopeType, options.projectSettingsUrl);
        }

        function rowDeleteClicked(e) {
            e.preventDefault();
            var $row = $(this).closest('tr');
            $row.addClass('active');
            $content.append(aui.dialog.dialog2({
                content: AJS.I18n.getText('bitbucket.defaultreviewers.settings.table.actions.delete.confirm.content'),
                modal: true,
                removeOnHide: true,
                id: DELETE_DIALOG_ID,
                size: 'small',
                titleText: AJS.I18n.getText('bitbucket.defaultreviewers.settings.table.actions.delete.confirm.header'),
                extraClasses: 'aui-dialog2-warning',
                footerActionContent: bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.defaultReviewers.confirmCancelButtons()
            }));
            var dialog = AJS.dialog2('#' + DELETE_DIALOG_ID);
            dialog.on('hide', deleteDialogHidden);
            dialog.show();
            dialog.$el.find('.delete-cancel-button').focus();
        }

        function rowEditClicked(e) {
            e.preventDefault();
            var id = $(this).closest('tr').attr('data-id');
            var dialog = new DefaultReviewersDialog({
                scopeType: options.scopeType,
                defaultReviewerSet: defaultReviewers.get(id),
                dialogOptions: {
                    isEditing: true,
                    callback: saveToCollection
                }
            });
            dialog.show();
        }

        function deleteDialogCancelClicked(e) {
            AJS.dialog2('#' + DELETE_DIALOG_ID).hide();
        }

        function deleteDialogConfirmClicked(e) {
            e.preventDefault();

            var $row = $content.find('tr.active');
            var dialog = AJS.dialog2('#' + DELETE_DIALOG_ID);
            dialog.hide();

            DefaultReviewersTableView.showRowSpinner($row);
            DefaultReviewersTableView.hideActionButtons($row);

            var currentScopeNavMethod = scopeTypeUtil.scopeNavAndStateMethod(options.scopeType);
            var id = $row.data('id');
            var urlBuilder = nav.rest('default-reviewers', 'latest')[currentScopeNavMethod.nav](pageState[currentScopeNavMethod.state]()).addPathComponents('condition').addPathComponents(id);

            server.rest({
                contentType: 'application/json',
                url: urlBuilder.build(),
                type: 'DELETE',
                statusCode: {
                    404: function _() {
                        defaultReviewers.remove(id);

                        return false;
                    }
                }
            }).done(function () {
                AJS.flag({
                    type: 'success',
                    title: AJS.I18n.getText('bitbucket.defaultreviewers.settings.removed.success'),
                    persistent: false,
                    close: 'auto',
                    body: ''
                });
                defaultReviewers.remove(id);
            }).fail(function () {
                DefaultReviewersTableView.showActionButtons($row);
            }).always(function () {
                DefaultReviewersTableView.hideRowSpinner($row);
            });
        }

        function deleteDialogHidden(e) {
            $content.find('tr.active').removeClass('active');
        }

        populateBranchModelBranches(options.scopeType, options.projectSettingsUrl);
    }

    var populateBranchModelBranches = function populateBranchModelBranches(scopeType, projectSettingsUrl) {
        var $categorySets = $('td[data-branch-type="' + SupportedMatcherTypes.MODEL_CATEGORY + '"]');
        var $branchSets = $('td[data-branch-type="' + SupportedMatcherTypes.MODEL_BRANCH + '"]');

        if (!$categorySets.length && !$branchSets.length) {
            return;
        }
        var currentScopeMethod = scopeTypeUtil.scopeNavAndStateMethod(scopeType);
        var urlBuilder = nav.rest('branch-utils', 'latest')[currentScopeMethod.nav](pageState[currentScopeMethod.state]()).addPathComponents('branchmodel');

        if (scopeType === ScopeType.PROJECT) {
            urlBuilder = urlBuilder.addPathComponents('configuration');
        }
        server.rest({
            url: urlBuilder.build(),
            statusCode: {
                '*': false
            }
        }).then(function (response) {
            var branchModelLink = nav.pluginServlets().path('branchmodel')[currentScopeMethod.nav](pageState[currentScopeMethod.state]()).build();

            function replaceBranchName($el, branchName) {
                var $branchName = $el.find('.branch-name');
                var effectiveScopeType = $branchName.closest('tr').attr('data-effective-scope-type');
                var resolvedScopeType = scopeTypeUtil.resolveForScopeType(scopeType);
                var resolvedEffectiveScopeType = scopeTypeUtil.resolveForScopeType(effectiveScopeType);
                $branchName.replaceWith(bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.defaultReviewers.branchName({
                    isABranch: true,
                    branchName: branchName,
                    scopeType: scopeType,
                    effectiveScopeType: effectiveScopeType,
                    projectSettingsUrl: projectSettingsUrl,
                    matcherType: SupportedMatcherTypes.MODEL_BRANCH,
                    showProjectUrl: resolvedScopeType.REPOSITORY && resolvedEffectiveScopeType.PROJECT
                }));
            }

            function updateBranchingModelBranch(type, displayId, descriptionHTML) {
                var $el = $('[data-branch-value=' + type + ']');
                replaceBranchName($el, displayId);
                $el.find('.branch-model-branch').html(descriptionHTML);
            }

            if (response.development) {
                updateBranchingModelBranch('development', response.development.refId || response.development.displayId || AJS.I18n.getText('bitbucket.defaultreviewers.settings.model.default.branch'), AJS.I18n.getText('bitbucket.defaultreviewers.settings.table.cell.model.branch.development.description.html', branchModelLink));
            }

            if (response.production) {
                updateBranchingModelBranch('production', response.production.refId || response.production.displayId || AJS.I18n.getText('bitbucket.defaultreviewers.settings.model.default.branch'), AJS.I18n.getText('bitbucket.defaultreviewers.settings.table.cell.model.branch.production.description.html', branchModelLink));
            }

            if (response.types) {
                response.types.forEach(function (type) {
                    var $type = $('[data-branch-value="' + type.id + '"]');
                    $type.find('.branch-name-text').text(type.prefix);
                    $type.find('.branch-model-category').html(bitbucketPluginDefaultReviewers.internal.feature.defaultReviewers.defaultReviewers.description({
                        displayName: type.displayName,
                        branchModelLink: branchModelLink
                    }));
                });
            }
        });
    };

    exports.onReady = function (options) {
        $(document).ready(function () {
            onReady(options);
        });
    };
});