define('bitbucket/internal/bbui/aui-react/avatar', ['exports', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/impl/urls'], function (exports, _aui, _classnames, _propTypes, _react, _enums, _urls) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Avatar = exports.ProjectAvatar = exports.UserAvatar = undefined;

    var AJS = _interopRequireWildcard(_aui);

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _urls2 = _interopRequireDefault(_urls);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    /*
     * This file exposes a default UserAvatar, and a named ProjectAvatar.
     */

    var commonPropTypes = {
        avatarAttrs: _propTypes2.default.object,
        avatarClassName: _propTypes2.default.string,
        // A list of possible badges to show for this avatar.
        // These will always be present in the DOM, for animation purposes
        badges: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            className: _propTypes2.default.string,
            // for accessibility
            text: _propTypes2.default.string
        })),
        // Will be set on the outer-most element
        className: _propTypes2.default.string,
        //Will be set on the link if `withLink` is true
        linkClassName: _propTypes2.default.string,
        // T-shirt sizing
        size: _propTypes2.default.string,
        // Set to false when `withName` is true
        tooltip: _propTypes2.default.bool,
        tooltipText: _propTypes2.default.string,
        // The single (if any) badge class name to be shown
        visibleBadge: _propTypes2.default.string,
        withLink: _propTypes2.default.bool,
        withName: _propTypes2.default.bool,
        withEmail: _propTypes2.default.bool
    };

    /*eslint-enable no-magic-numbers*/

    var UserAvatar = function UserAvatar(_ref) {
        var _ref$badges = _ref.badges,
            badges = _ref$badges === undefined ? [] : _ref$badges,
            _ref$size = _ref.size,
            size = _ref$size === undefined ? 'small' : _ref$size,
            _ref$tooltip = _ref.tooltip,
            tooltip = _ref$tooltip === undefined ? true : _ref$tooltip,
            _ref$tooltipText = _ref.tooltipText,
            tooltipText = _ref$tooltipText === undefined ? '' : _ref$tooltipText,
            _ref$withName = _ref.withName,
            withName = _ref$withName === undefined ? false : _ref$withName,
            _ref$withEmail = _ref.withEmail,
            withEmail = _ref$withEmail === undefined ? false : _ref$withEmail,
            props = _objectWithoutProperties(_ref, ['badges', 'size', 'tooltip', 'tooltipText', 'withName', 'withEmail']);

        var user = props.person.user || props.person;
        var displayableName = user.displayName || user.name;
        var fallbackTooltip = displayableName;

        var display = [];

        if (withName) {
            display.push(displayableName);
        }
        if (withEmail && user.emailAddress) {
            fallbackTooltip += ' (' + user.emailAddress + ')';
            display.push(_react2.default.createElement(
                'span',
                { key: 'email', className: 'email-address' },
                user.emailAddress
            ));
        }
        var avatarProps = {
            alt: displayableName,
            avatarAttrs: { 'data-username': user.name },
            avatarSrc: _urls2.default.avatarUrl(user, _enums.AvatarSize[size.toUpperCase()]),
            badges: badges,
            className: (0, _classnames2.default)('user-avatar', props.avatarClassName, { 'badge-hidden': props.hideBadge }, withName || withEmail ? null : props.className),
            display: display,
            displayLink: props.withLink ? _urls2.default.user(user) : undefined,
            linkClassName: props.withLink ? props.linkClassName : undefined,
            size: size,
            title: tooltip && (tooltipText || fallbackTooltip),
            tooltip: tooltip,
            visibleBadge: props.visibleBadge
        };

        return _react2.default.createElement(AvatarWrapper, {
            className: props.className,
            withLink: props.withLink,
            withName: withName,
            avatarProps: avatarProps
        });
    };
    exports.UserAvatar = UserAvatar;
    UserAvatar.propTypes = _extends({}, commonPropTypes, {
        person: _propTypes2.default.object.isRequired
    });

    var ProjectAvatar = function ProjectAvatar(_ref2) {
        var _ref2$badges = _ref2.badges,
            badges = _ref2$badges === undefined ? [] : _ref2$badges,
            _ref2$size = _ref2.size,
            size = _ref2$size === undefined ? 'small' : _ref2$size,
            _ref2$tooltip = _ref2.tooltip,
            tooltip = _ref2$tooltip === undefined ? true : _ref2$tooltip,
            _ref2$withName = _ref2.withName,
            withName = _ref2$withName === undefined ? false : _ref2$withName,
            props = _objectWithoutProperties(_ref2, ['badges', 'size', 'tooltip', 'withName']);

        var avatarProps = {
            alt: props.project.name,
            avatarSrc: props.project.avatarUrl ? _urls2.default.avatarUrl(props.project, _enums.AvatarSize[size.toUpperCase()]) : function () {
                throw new Error('No avatar URL provided: ' + JSON.stringify(props));
            }(),
            badges: badges,
            isProject: true,
            display: props.project.name,
            displayLink: 'XXX TODO TEST',
            size: size,
            title: props.project.name,
            tooltip: tooltip,
            visibleBadge: props.visibleBadge
        };

        return _react2.default.createElement(AvatarWrapper, {
            className: props.className,
            withLink: props.withLink,
            withName: withName,
            avatarProps: avatarProps
        });
    };

    exports.ProjectAvatar = ProjectAvatar;
    ProjectAvatar.propTypes = _extends({}, commonPropTypes, {
        project: _propTypes2.default.object.isRequired
    });

    /**
     * An AUI avatar.
     *
     * @param {Object} props - The component properties
     * @param {string} props.alt - The text equivalent of the avatar
     * @param {string} props.avatarSrc - The URL to the avatar image
     * @param {Object} [props.avatarAttrs] - Attributes to be added to the top level avatar element
     * @param {string} [props.size=small] - The avatar size (using t-shirt sizes)
     * @param {string} [props.className] - Classes to be added to the top level avatar element
     * @param {Array} [props.badges] - Array of badges containing a `className` and optional `text`
     * @param {boolean} [props.isProject] - Renders avatar with project shape (square)
     * @param {string} props.title - Tooltip text for the avatar
     * @param {boolean} [props.tooltip=true] - Whether to show a tooltip for the avatar
     * @param {string} [props.visibleBadge] - Badges are visible
     * @returns {ReactElement} The rendered component
     */
    var Avatar = exports.Avatar = function Avatar(_ref3) {
        var _ref3$alt = _ref3.alt,
            alt = _ref3$alt === undefined ? null : _ref3$alt,
            _ref3$avatarAttrs = _ref3.avatarAttrs,
            avatarAttrs = _ref3$avatarAttrs === undefined ? {} : _ref3$avatarAttrs,
            avatarSrc = _ref3.avatarSrc,
            _ref3$badges = _ref3.badges,
            badges = _ref3$badges === undefined ? [] : _ref3$badges,
            _ref3$isProject = _ref3.isProject,
            isProject = _ref3$isProject === undefined ? false : _ref3$isProject,
            _ref3$className = _ref3.className,
            className = _ref3$className === undefined ? null : _ref3$className,
            _ref3$size = _ref3.size,
            size = _ref3$size === undefined ? 'small' : _ref3$size,
            _ref3$title = _ref3.title,
            title = _ref3$title === undefined ? null : _ref3$title,
            _ref3$tooltip = _ref3.tooltip,
            tooltip = _ref3$tooltip === undefined ? false : _ref3$tooltip,
            _ref3$visibleBadge = _ref3.visibleBadge,
            visibleBadge = _ref3$visibleBadge === undefined ? null : _ref3$visibleBadge;

        var avatarClassNames = (0, _classnames2.default)(className, 'aui-avatar', 'aui-avatar-' + size, {
            'aui-avatar-badged': badges.length,
            'aui-avatar-project': isProject
        });

        var imgAttrs = {
            alt: alt,
            ref: tooltip ? function (el) {
                return AJS.$(el).tooltip();
            } : null,
            src: avatarSrc,
            title: tooltip ? title : undefined
        };

        return _react2.default.createElement(
            'span',
            _extends({ className: avatarClassNames }, avatarAttrs),
            _react2.default.createElement(
                'span',
                { className: 'aui-avatar-inner' },
                _react2.default.createElement('img', _extends({ alt: imgAttrs.alt }, imgAttrs))
            ),
            badges.map(function (badge) {
                return _react2.default.createElement(
                    'span',
                    {
                        key: badge.className,
                        className: (0, _classnames2.default)('badge', badge.className, {
                            'badge-hidden': visibleBadge !== badge.className
                        }),
                        'aria-hidden': !visibleBadge
                    },
                    badge.text
                );
            })
        );
    };

    Avatar.propTypes = {
        alt: _propTypes2.default.string,
        avatarAttrs: _propTypes2.default.object,
        avatarSrc: _propTypes2.default.string.isRequired,
        badges: _propTypes2.default.array,
        isProject: _propTypes2.default.bool,
        className: _propTypes2.default.string,
        size: _propTypes2.default.string,
        title: _propTypes2.default.oneOfType([_propTypes2.default.bool, _propTypes2.default.string]),
        tooltip: _propTypes2.default.bool,
        visibleBadge: _propTypes2.default.string
    };

    /**
     * A wrapper to determine whether to show the avatar's display name or not.
     * @param {Object} props - The component props
     * @returns {ReactElement}
     */
    var AvatarWrapper = function AvatarWrapper(props) {
        var avatarProps = props.avatarProps;


        if (!props.withName) {
            return _react2.default.createElement(Avatar, _extends({}, avatarProps, {
                className: (0, _classnames2.default)(avatarProps.className, props.className)
            }));
        }

        return _react2.default.createElement(
            'div',
            {
                className: (0, _classnames2.default)(props.className, 'avatar-with-name'),
                title: avatarProps.tooltip ? avatarProps.title : undefined
            },
            _react2.default.createElement(Avatar, _extends({}, avatarProps, { tooltip: false })),
            _react2.default.createElement(AvatarDisplay, {
                display: avatarProps.display,
                href: props.withLink ? avatarProps.displayLink : undefined,
                className: props.withLink ? avatarProps.linkClassName : undefined
            })
        );
    };

    /**
     * The display name for an avatar, which may or may not be linked.
     * @param {Object} props - Component props
     * @returns {ReactElement}
     */
    var AvatarDisplay = function AvatarDisplay(props) {
        var display = props.display,
            href = props.href,
            className = props.className;


        if (href) {
            return _react2.default.createElement(
                'a',
                { className: (0, _classnames2.default)('name', className), href: href },
                display
            );
        }

        return _react2.default.createElement(
            'span',
            { className: 'name' },
            display
        );
    };
});