define('bitbucket/internal/bbui/aui-react/form', ['exports', 'classnames', 'prop-types', 'react'], function (exports, _classnames, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Radio = exports.RadioGroup = exports.Checkbox = exports.TextField = exports.Warnings = exports.Errors = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var Errors = function Errors(_ref) {
        var errors = _ref.errors;

        if (errors.length === 1) {
            return _react2.default.createElement(
                'p',
                { className: 'error' },
                _react2.default.createElement('span', { className: 'aui-icon aui-icon-small aui-iconfont-error' }),
                errors[0]
            );
        }

        return _react2.default.createElement(
            'ul',
            { className: 'error' },
            errors.map(function (err) {
                return _react2.default.createElement(
                    'li',
                    { key: err },
                    err
                );
            })
        );
    };

    Errors.propTypes = {
        errors: _propTypes2.default.array.isRequired
    };

    var Warnings = function Warnings(_ref2) {
        var warnings = _ref2.warnings;

        if (warnings.length === 1) {
            return _react2.default.createElement(
                'p',
                { className: 'warning' },
                _react2.default.createElement('span', { className: 'aui-icon aui-icon-small aui-iconfont-warning' }),
                warnings[0]
            );
        }

        return _react2.default.createElement(
            'ul',
            { className: 'warning' },
            warnings.map(function (warn) {
                return _react2.default.createElement(
                    'li',
                    { key: warn },
                    warn
                );
            })
        );
    };

    Warnings.propTypes = {
        warnings: _propTypes2.default.array.isRequired
    };

    var TextField = function TextField(_ref3) {
        var _ref3$required = _ref3.required,
            required = _ref3$required === undefined ? false : _ref3$required,
            title = _ref3.title,
            name = _ref3.name,
            description = _ref3.description,
            descriptionHtml = _ref3.descriptionHtml,
            onChange = _ref3.onChange,
            value = _ref3.value,
            errors = _ref3.errors,
            size = _ref3.size,
            maxLength = _ref3.maxLength,
            _ref3$autoFocus = _ref3.autoFocus,
            autoFocus = _ref3$autoFocus === undefined ? false : _ref3$autoFocus,
            _ref3$autoComplete = _ref3.autoComplete,
            autoComplete = _ref3$autoComplete === undefined ? true : _ref3$autoComplete,
            _ref3$disabled = _ref3.disabled,
            disabled = _ref3$disabled === undefined ? false : _ref3$disabled,
            _ref3$type = _ref3.type,
            type = _ref3$type === undefined ? 'text' : _ref3$type,
            min = _ref3.min,
            step = _ref3.step,
            warnings = _ref3.warnings;

        var requiredElement = required ? _react2.default.createElement(
            'span',
            { className: 'aui-icon icon-required' },
            '(required)'
        ) : null;
        var descriptionDiv = descriptionHtml ? _react2.default.createElement('div', { className: 'description', dangerouslySetInnerHTML: descriptionHtml }) : _react2.default.createElement(
            'div',
            { className: 'description' },
            description
        );

        var renderError = Array.isArray(errors) && errors.length > 0;
        // Only render warnings if there are no errors.
        var renderWarning = Array.isArray(warnings) && warnings.length > 0 && !renderError;

        return _react2.default.createElement(
            'div',
            { className: 'field-group aui-react-text-field' },
            _react2.default.createElement(
                'label',
                { htmlFor: name },
                title,
                requiredElement
            ),
            _react2.default.createElement('input', {
                className: (0, _classnames2.default)('text', size && size + '-field', renderError && 'error-outline', renderWarning && 'warning-outline'),
                type: type,
                id: name,
                name: name,
                value: value,
                onChange: onChange,
                maxLength: maxLength,
                autoFocus: autoFocus,
                autoComplete: autoComplete ? 'on' : 'off',
                disabled: disabled,
                min: min,
                step: step
            }),
            renderError ? _react2.default.createElement(Errors, { errors: errors }) : null,
            renderWarning ? _react2.default.createElement(Warnings, { warnings: warnings }) : null,
            descriptionDiv
        );
    };

    TextField.propTypes = {
        required: _propTypes2.default.bool,
        description: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.object]),
        descriptionHtml: _propTypes2.default.object,
        title: _propTypes2.default.string.isRequired,
        name: _propTypes2.default.string.isRequired,
        onChange: _propTypes2.default.func,
        value: _propTypes2.default.string,
        errors: _propTypes2.default.array,
        warnings: _propTypes2.default.array,
        size: _propTypes2.default.oneOf(['short', 'medium', 'medium-long', 'long', 'full-width']),
        maxLength: _propTypes2.default.number,
        autoFocus: _propTypes2.default.bool,
        autoComplete: _propTypes2.default.bool,
        disabled: _propTypes2.default.bool,
        type: _propTypes2.default.string,
        min: _propTypes2.default.number,
        step: _propTypes2.default.number
    };

    var Checkbox = function Checkbox(_ref4) {
        var _ref4$checked = _ref4.checked,
            checked = _ref4$checked === undefined ? false : _ref4$checked,
            description = _ref4.description,
            _ref4$disabled = _ref4.disabled,
            disabled = _ref4$disabled === undefined ? false : _ref4$disabled,
            label = _ref4.label,
            name = _ref4.name,
            id = _ref4.id,
            onChange = _ref4.onChange,
            autoFocus = _ref4.autoFocus;
        return _react2.default.createElement(
            'div',
            { className: 'checkbox' },
            _react2.default.createElement('input', {
                'data-grouping': 'trigger',
                className: 'checkbox',
                type: 'checkbox',
                name: name,
                id: id || name,
                onChange: onChange,
                checked: checked,
                disabled: disabled,
                autoFocus: autoFocus
            }),
            _react2.default.createElement(
                'label',
                { htmlFor: id || name },
                label
            ),
            _react2.default.createElement(
                'div',
                { className: 'description' },
                description
            )
        );
    };
    Checkbox.propTypes = {
        checked: _propTypes2.default.bool,
        description: _propTypes2.default.string,
        disabled: _propTypes2.default.bool,
        label: _propTypes2.default.string.isRequired,
        name: _propTypes2.default.string.isRequired,
        id: _propTypes2.default.string,
        onChange: _propTypes2.default.func,
        autoFocus: _propTypes2.default.bool
    };

    var RadioGroup = function RadioGroup(_ref5) {
        var children = _ref5.children,
            name = _ref5.name,
            label = _ref5.label,
            onChange = _ref5.onChange,
            value = _ref5.value,
            _ref5$className = _ref5.className,
            className = _ref5$className === undefined ? '' : _ref5$className;

        var radios = _react2.default.Children.map(children, function (child, index) {
            return _react2.default.cloneElement(child, {
                id: child.props.id || name + '-' + (index + 1),
                name: name,
                onChange: onChange,
                checked: value === child.props.value
            });
        });

        return _react2.default.createElement(
            'fieldset',
            { className: 'group ' + className },
            _react2.default.createElement(
                'legend',
                null,
                _react2.default.createElement(
                    'span',
                    null,
                    label
                )
            ),
            radios
        );
    };

    RadioGroup.propTypes = {
        children: _propTypes2.default.node,
        className: _propTypes2.default.string,
        label: _propTypes2.default.string.isRequired,
        name: _propTypes2.default.string.isRequired,
        onChange: _propTypes2.default.func.isRequired,
        value: _propTypes2.default.string
    };

    var Radio = function Radio(_ref6) {
        var id = _ref6.id,
            name = _ref6.name,
            label = _ref6.label,
            _onChange = _ref6.onChange,
            checked = _ref6.checked,
            value = _ref6.value,
            description = _ref6.description,
            autoFocus = _ref6.autoFocus;
        return _react2.default.createElement(
            'div',
            { className: 'radio' },
            _react2.default.createElement('input', {
                autoFocus: autoFocus,
                className: 'radio',
                type: 'radio',
                checked: checked,
                name: name,
                id: id || name,
                onChange: function onChange() {
                    return _onChange(value);
                }
            }),
            _react2.default.createElement(
                'label',
                { htmlFor: id || name },
                label
            ),
            description && _react2.default.createElement(
                'div',
                { className: 'description' },
                description
            )
        );
    };

    Radio.propTypes = {
        name: _propTypes2.default.string, // not required because it's provided by RadioGroup
        id: _propTypes2.default.string,
        checked: _propTypes2.default.bool,
        label: _propTypes2.default.oneOfType([_propTypes2.default.string.isRequired, _propTypes2.default.object.isRequired]), // accepts object as a type to allow for icons
        onChange: _propTypes2.default.func, // not "required" because it's provided by RadioGroup
        value: _propTypes2.default.string.isRequired,
        description: _propTypes2.default.string,
        autoFocus: _propTypes2.default.bool
    };

    exports.Errors = Errors;
    exports.Warnings = Warnings;
    exports.TextField = TextField;
    exports.Checkbox = Checkbox;
    exports.RadioGroup = RadioGroup;
    exports.Radio = Radio;
});