define('bitbucket/internal/bbui/aui-react/inline-dialog', ['exports', 'classnames', 'lodash', 'prop-types', 'react', 'react-dom', './component'], function (exports, _classnames, _lodash, _propTypes, _react, _reactDom, _component) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.InlineDialogTrigger = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _component2 = _interopRequireDefault(_component);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var InlineDialogTrigger = exports.InlineDialogTrigger = function (_Component) {
        _inherits(InlineDialogTrigger, _Component);

        function InlineDialogTrigger(props) {
            _classCallCheck(this, InlineDialogTrigger);

            var _this = _possibleConstructorReturn(this, (InlineDialogTrigger.__proto__ || Object.getPrototypeOf(InlineDialogTrigger)).call(this, props));

            _this.elementType = 'button';

            _this.triggerProps = {
                'aria-controls': props.dialogId,
                'aria-haspopup': true,
                className: (0, _classnames2.default)('aui-button', props.className),
                'data-aui-trigger': true,
                role: 'button',
                title: props.title,
                onFocus: props.onFocus,
                onBlur: props.onBlur
            };

            if (props.href) {
                _this.triggerProps = _extends({}, _this.triggerProps, {
                    className: props.className,
                    href: props.href,
                    tabIndex: '0'
                });
                _this.elementType = 'a';
            }
            return _this;
        }

        _createClass(InlineDialogTrigger, [{
            key: 'render',
            value: function render() {
                return _react2.default.createElement(this.elementType, this.triggerProps, this.props.children);
            }
        }]);

        return InlineDialogTrigger;
    }(_react.Component);

    InlineDialogTrigger.propTypes = {
        children: _propTypes2.default.node,
        className: _propTypes2.default.string,
        dialogId: _propTypes2.default.string.isRequired,
        href: _propTypes2.default.string,
        title: _propTypes2.default.string,
        onFocus: _propTypes2.default.func,
        onBlur: _propTypes2.default.func
    };
    InlineDialogTrigger.defaultProps = {
        className: '',
        href: '',
        title: ''
    };

    var InlineDialog = function (_Component2) {
        _inherits(InlineDialog, _Component2);

        function InlineDialog() {
            var _ref;

            var _temp, _this2, _ret;

            _classCallCheck(this, InlineDialog);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this2 = _possibleConstructorReturn(this, (_ref = InlineDialog.__proto__ || Object.getPrototypeOf(InlineDialog)).call.apply(_ref, [this].concat(args))), _this2), _this2.onHide = function (e) {
                if ((0, _lodash.isFunction)(_this2.props.onHide)) {
                    (0, _lodash.defer)(function () {
                        return _this2.props.onHide(e);
                    });
                }
            }, _this2.onShow = function (e) {
                if ((0, _lodash.isFunction)(_this2.props.onShow)) {
                    (0, _lodash.defer)(function () {
                        return _this2.props.onShow(e);
                    });
                }
            }, _temp), _possibleConstructorReturn(_this2, _ret);
        }

        _createClass(InlineDialog, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                // scope the event listeners to the current inline dialog only
                this._el = (0, _reactDom.findDOMNode)(this).querySelector('aui-inline-dialog');
                this._el.addEventListener('aui-hide', this.onHide);
                this._el.addEventListener('aui-show', this.onShow);
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                this._el.removeEventListener('aui-hide', this.onHide);
                this._el.removeEventListener('aui-show', this.onShow);
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    alignment = _props.alignment,
                    children = _props.children,
                    className = _props.className,
                    id = _props.id,
                    respondsTo = _props.respondsTo;


                return _react2.default.createElement(
                    _component2.default,
                    {
                        id: id,
                        markup: '<aui-inline-dialog\n                            id="' + id + '"\n                            class="' + className + '"\n                            alignment="' + alignment + '"\n                            responds-to="' + respondsTo + '"\n                         ></aui-inline-dialog>',
                        containerSelector: '#' + id + ' .aui-inline-dialog-contents'
                    },
                    children
                );
            }
        }]);

        return InlineDialog;
    }(_react.Component);

    InlineDialog.propTypes = {
        alignment: _propTypes2.default.string,
        children: _propTypes2.default.node,
        className: _propTypes2.default.string,
        id: _propTypes2.default.string.isRequired,
        onHide: _propTypes2.default.func,
        onShow: _propTypes2.default.func,
        respondsTo: _propTypes2.default.oneOf(['toggle', 'hover'])
    };
    InlineDialog.defaultProps = {
        alignment: 'right middle',
        className: '',
        respondsTo: 'toggle'
    };
    exports.default = InlineDialog;
});