define('bitbucket/internal/bbui/aui-react/spinner', ['exports', 'prop-types', 'react', '@atlassian/aui'], function (exports, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.SpinnerSize = undefined;

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    // We depend on the spinner
    var SpinnerSize = exports.SpinnerSize = {
        SMALL: 'small',
        MEDIUM: 'medium',
        LARGE: 'large'
    };

    function Spinner(_ref) {
        var _ref$size = _ref.size,
            size = _ref$size === undefined ? SpinnerSize.SMALL : _ref$size,
            _ref$filled = _ref.filled,
            filled = _ref$filled === undefined ? false : _ref$filled;

        return _react2.default.createElement('aui-spinner', { size: size, filled: filled ? '' : undefined });
    }

    Spinner.propTypes = {
        size: _propTypes2.default.oneOf([SpinnerSize.SMALL, SpinnerSize.MEDIUM, SpinnerSize.LARGE]),
        filled: _propTypes2.default.bool
    };

    exports.default = (0, _react.memo)(Spinner);
});