define('bitbucket/internal/bbui/filter-bar/components/async-select', ['module', 'exports', 'classnames', 'jquery', 'lodash', 'prop-types', 'react', 'react-dom', 'bitbucket/internal/util/navigator', './filter'], function (module, exports, _classnames, _jquery, _lodash, _propTypes, _react, _reactDom, _navigator, _filter) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _filter2 = _interopRequireDefault(_filter);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var AsyncSelect = function (_Filter) {
        _inherits(AsyncSelect, _Filter);

        _createClass(AsyncSelect, null, [{
            key: 'propTypes',
            get: function get() {
                return {
                    id: _propTypes2.default.string.isRequired,
                    label: _propTypes2.default.string.isRequired,
                    loading: _propTypes2.default.bool,
                    menu: _propTypes2.default.any,
                    onChange: _propTypes2.default.func,
                    onMoreItemsRequested: _propTypes2.default.func.isRequired,
                    onResetRequested: _propTypes2.default.func.isRequired,
                    onTermChanged: _propTypes2.default.func.isRequired,
                    searchPlaceholder: _propTypes2.default.string,
                    value: _propTypes2.default.string
                };
            }
        }]);

        function AsyncSelect() {
            var _ref;

            _classCallCheck(this, AsyncSelect);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            var _this = _possibleConstructorReturn(this, (_ref = AsyncSelect.__proto__ || Object.getPrototypeOf(AsyncSelect)).call.apply(_ref, [this].concat(args)));

            _this._state = {
                pendingItems: [],
                pendingQuery: null,
                term: '',
                searchBoxSpinnerContainer: document.createElement('div'),
                moreResultsEl: null
            };
            return _this;
        }

        _createClass(AsyncSelect, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                var defaults = {
                    minimumInputLength: 0,
                    minimumResultsForSearch: 0,
                    dropdownAutoWidth: true,
                    formatSearching: function formatSearching() {
                        return AJS.I18n.getText('bitbucket.component.filter.bar.searching');
                    },
                    formatNoMatches: function formatNoMatches() {
                        return AJS.I18n.getText('bitbucket.component.filter.bar.nomatches');
                    }
                };
                var overrides = {
                    allowClear: true,
                    containerCssClass: (0, _classnames2.default)('filter-bar-async', this.props.menu.containerCssClass),
                    dropdownCssClass: (0, _classnames2.default)('filter-bar-async', 'filter-bar-dropdown-' + this.props.id, this.props.menu.dropdownCssClass),
                    query: function query(_query) {
                        if (_this2._state.pendingQuery && _query.page === _this2._state.pendingQuery.page && _query.term === _this2._state.pendingQuery.term) {
                            return; // Select2 is being dumb and calling query multiple times.
                        }

                        if (_query.page <= 1 || _this2._state.pendingQuery) {
                            _this2.props.onResetRequested(); // make sure the caller knows to start fresh with sending items.
                        }

                        if (_this2._state.term !== _query.term) {
                            _this2.props.onTermChanged(_query.term);
                        }

                        _this2._setState({
                            pendingQuery: _query,
                            term: _query.term,
                            moreResultsEl: document.getElementsByClassName('select2-more-results')[0]
                        }, function (state) {
                            _this2.props.onMoreItemsRequested(function (newItems) {
                                if (state.pendingQuery !== _query) {
                                    // something else happened in the meantime?
                                    return;
                                }

                                _this2._setState({
                                    pendingItems: state.pendingItems.concat(newItems)
                                });
                            });
                        });
                    },
                    formatLoadMore: function formatLoadMore() {
                        return ' ';
                    }, // blank out the default text because we're replacing it with the spinner
                    formatResult: function formatResult(value, $container) {
                        // eslint-disable-next-line react/no-deprecated
                        _reactDom2.default.render(_this2.props.menu.formatResult(value), $container[0]);

                        return value;
                    },
                    formatSelection: function formatSelection(value, $container) {
                        // eslint-disable-next-line react/no-deprecated
                        _reactDom2.default.render(_this2.props.menu.formatSelection(value), $container[0]);

                        return value;
                    },
                    ajax: undefined
                };

                var $filter = this.get$Input();
                $filter.auiSelect2(_lodash2.default.assign(defaults, this.props.menu, overrides));
                $filter.on('change', function () {
                    return _this2.props.onChange();
                });
                $filter.on('select2-opening', function (e) {
                    if ($filter.select2('val')) {
                        // if there's a selection, force the clearing of it instead of opening.
                        e.preventDefault();
                        // eslint-disable-next-line react/no-deprecated
                        _reactDom2.default.unmountComponentAtNode($filter.select2('container').find('.select2-chosen')[0]);
                        $filter.select2('val', '', true); // clear and trigger change
                    }
                });
                if (this.props.searchPlaceholder && !(0, _navigator.isIE)()) {
                    // IE11 & below will fail - see STASHDEV-10518
                    $filter.one('select2-open', function () {
                        // make sure it's filtered by specific dropdown so this only affects the select2 that $filter belongs to
                        (0, _jquery2.default)('.filter-bar-dropdown-' + _this2.props.id + ' .select2-search > input').attr('placeholder', _this2.props.searchPlaceholder).after(_this2._state.searchBoxSpinnerContainer);
                        if (_this2.props.loading) {
                            _this2.renderSpinner(_this2._state.searchBoxSpinnerContainer);
                        }
                    });
                }
            }
        }, {
            key: '_setState',
            value: function _setState() {
                var stateChanges = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
                var callback = arguments[1];

                var newState = _extends({}, this._state, stateChanges);
                this.reconcileComponent(this.props, newState);
                this._state = newState;
                if (callback) {
                    callback(newState);
                }
            }
        }, {
            key: 'reconcileComponent',
            value: function reconcileComponent(newProps, newState) {
                if (newProps.loading && newState.pendingQuery) {
                    // loading and there's a known query in the works
                    if (newState.pendingQuery.page <= 1 && newState.searchBoxSpinnerContainer.parentNode) {
                        this.renderSpinner(newState.searchBoxSpinnerContainer);
                    }
                    if (newState.moreResultsEl) {
                        this.renderSpinner(newState.moreResultsEl);
                    }
                } else if (!newProps.loading && this._state.pendingQuery && newState.pendingQuery) {
                    // loaded pre-existing query
                    if (newState.moreResultsEl) {
                        this.removeAllElements(newState.moreResultsEl);
                    }
                    if (newState.searchBoxSpinnerContainer.children.length) {
                        this.removeAllElements(newState.searchBoxSpinnerContainer);
                    }

                    var query = newState.pendingQuery; // grab the new one - grabbing the old one could get us into a loop.
                    var results = newState.pendingItems;
                    var more = !newProps.allFetched;

                    this._setState({
                        pendingQuery: null,
                        pendingItems: []
                    }, function () {
                        query.callback({
                            context: query.context,
                            results: results,
                            more: more
                        });
                    });
                }
            }
        }, {
            key: 'removeAllElements',
            value: function removeAllElements(parent) {
                // JQuery is used instead of ReactDOM.unmountComponentAtNode to avoid asynchronous operation causing DOMException
                // when user plays with the text box due to out of order events e.g. node is no more present in DOM at the time
                // react tries to remove it.
                (0, _jquery2.default)(parent).empty();
            }
        }, {
            key: 'renderSpinner',
            value: function renderSpinner(parent) {
                // JQuery is used instead of ReactDOM.render for consistency with removeAllElements which doesn't use React.
                (0, _jquery2.default)('<aui-spinner size="small" />').appendTo(parent);
            }
        }, {
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(newProps) {
                // since we're not using real state, this should only be called
                // when we get new props. So calling it here should be the same as
                // UNSAFE_componentWillReceiveProps()
                this.reconcileComponent(newProps, this._state);

                // Note - we return false so that render never reruns.
                return false;
            }
        }, {
            key: 'get$Input',
            value: function get$Input() {
                return (0, _jquery2.default)(_reactDom2.default.findDOMNode(this)).children('input');
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(
                    'li',
                    null,
                    _react2.default.createElement(
                        'label',
                        { htmlFor: this.props.id, className: 'assistive' },
                        this.props.label
                    ),
                    _react2.default.createElement('input', { type: 'hidden', id: this.props.id, value: this.props.value || '' })
                );
            }
        }, {
            key: 'value',
            value: function value() {
                return this.props.value;
            }
        }, {
            key: 'domValue',
            value: function domValue() {
                return this.get$Input().val();
            }
        }, {
            key: 'set',
            value: function set(value) {
                var $filter = this.get$Input();
                // eslint-disable-next-line react/no-deprecated
                _reactDom2.default.unmountComponentAtNode($filter.select2('container').find('.select2-chosen')[0]);
                $filter.select2('val', value);

                return _jquery2.default.Deferred().resolve();
            }
        }]);

        return AsyncSelect;
    }(_filter2.default);

    exports.default = AsyncSelect;
    module.exports = exports['default'];
});