define('bitbucket/internal/bbui/filter-bar/components/input', ['module', 'exports', 'lodash', 'prop-types', 'react', './filter'], function (module, exports, _lodash, _propTypes, _react, _filter) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _filter2 = _interopRequireDefault(_filter);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var ESCAPE_KEY = 27;

    var Input = function (_Filter) {
        _inherits(Input, _Filter);

        function Input(props) {
            _classCallCheck(this, Input);

            var _this = _possibleConstructorReturn(this, (Input.__proto__ || Object.getPrototypeOf(Input)).call(this, props));

            _this.inputRef = (0, _react.createRef)();

            _this.handleClearingInputField = function (event) {
                // eslint-disable-next-line no-magic-numbers
                var isComposing = event.isComposing || event.keyCode === 229;

                if (isComposing) {
                    return;
                }

                if (event.keyCode === ESCAPE_KEY) {
                    var input = event.target;

                    // https://stackoverflow.com/a/46012210
                    // Clean input value and trigger a DOM change event that will trigger React event
                    var nativeInputValueSetter = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(input), 'value').set;
                    nativeInputValueSetter.call(input, '');

                    var inputEvent = new Event('input', { bubbles: true });
                    input.dispatchEvent(inputEvent);
                }
            };

            _this.onChangeDebounced = (0, _lodash.debounce)(_this.props.onChange, _this.props.debounce);
            return _this;
        }

        _createClass(Input, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    value = _props.value,
                    label = _props.label,
                    className = _props.className,
                    id = _props.id,
                    props = _objectWithoutProperties(_props, ['value', 'label', 'className', 'id']);

                return _react2.default.createElement(
                    'li',
                    { className: 'paged-table-filter-input-wrapper' },
                    _react2.default.createElement('span', { className: 'aui-icon aui-icon-small aui-iconfont-search' }),
                    _react2.default.createElement(
                        'label',
                        { htmlFor: id, className: 'assistive' },
                        label
                    ),
                    _react2.default.createElement('input', _extends({}, props, {
                        id: id,
                        ref: this.inputRef,
                        placeholder: label,
                        onChange: this.onChangeDebounced,
                        onKeyDown: this.handleClearingInputField,
                        type: 'text',
                        className: className,
                        defaultValue: value
                    }))
                );
            }
        }, {
            key: 'value',
            value: function value() {
                return this.props.value;
            }
        }, {
            key: 'domValue',
            value: function domValue() {
                return this.inputRef.current.value.trim();
            }
        }, {
            key: 'set',
            value: function set(value) {
                this.inputRef.current.value = value;
            }
        }]);

        return Input;
    }(_filter2.default);

    Input.propTypes = {
        id: _propTypes.string.isRequired,
        label: _propTypes.string.isRequired,
        onChange: _propTypes.func,
        value: _propTypes.string,
        className: _propTypes.string,
        debounce: _propTypes.number
    };
    Input.defaultProps = {
        onChange: function onChange() {},
        value: null,
        className: null,
        debounce: 350
    };
    exports.default = Input;
    module.exports = exports['default'];
});