define('bitbucket/internal/bbui/filter-bar/components/toggle', ['module', 'exports', 'jquery', 'prop-types', 'react', './filter'], function (module, exports, _jquery, _propTypes, _react, _filter) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _filter2 = _interopRequireDefault(_filter);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var Toggle = function (_Filter) {
        _inherits(Toggle, _Filter);

        _createClass(Toggle, null, [{
            key: 'propTypes',
            get: function get() {
                return {
                    id: _propTypes2.default.string.isRequired,
                    label: _propTypes2.default.string.isRequired,
                    onChange: _propTypes2.default.func,
                    value: _propTypes2.default.bool.isRequired,
                    isCheckbox: _propTypes2.default.bool
                };
            }
        }]);

        function Toggle() {
            var _ref;

            _classCallCheck(this, Toggle);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            var _this = _possibleConstructorReturn(this, (_ref = Toggle.__proto__ || Object.getPrototypeOf(Toggle)).call.apply(_ref, [this].concat(args)));

            _this.state = {
                pressed: _this.props.value
            };
            return _this;
        }

        _createClass(Toggle, [{
            key: 'onChange',
            value: function onChange() {
                var _this2 = this;

                this.setState(function (prevState) {
                    return {
                        pressed: !prevState.pressed
                    };
                }, function () {
                    if (_this2.props.onChange) {
                        _this2.props.onChange();
                    }
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                if (this.props.isCheckbox) {
                    // AUI form defines the styles and a11y for AUI checkbox, as these filters aren't
                    // wrapped in an AUI form, we wrap the checkbox on an AUI form
                    return _react2.default.createElement(
                        'li',
                        null,
                        _react2.default.createElement(
                            'div',
                            { className: 'filter-bar-checkbox' },
                            _react2.default.createElement(
                                'form',
                                { className: 'aui' },
                                _react2.default.createElement(
                                    'div',
                                    { className: 'checkbox' },
                                    _react2.default.createElement('input', {
                                        id: this.props.id,
                                        onChange: function onChange() {
                                            return _this3.onChange();
                                        },
                                        type: 'checkbox',
                                        className: 'checkbox',
                                        defaultChecked: this.props.value
                                    }),
                                    _react2.default.createElement(
                                        'label',
                                        { htmlFor: this.props.id },
                                        this.props.label
                                    )
                                )
                            )
                        )
                    );
                }

                return _react2.default.createElement(
                    'li',
                    null,
                    _react2.default.createElement(
                        'button',
                        {
                            className: 'aui-button aui-button-subtle',
                            id: this.props.id,
                            'aria-pressed': this.state.pressed,
                            onClick: function onClick() {
                                return _this3.onChange();
                            }
                        },
                        this.props.label
                    )
                );
            }
        }, {
            key: 'value',
            value: function value() {
                return this.props.value;
            }
        }, {
            key: 'domValue',
            value: function domValue() {
                return this.state.pressed;
            }
        }, {
            key: 'set',
            value: function set(value) {
                var def = _jquery2.default.Deferred();
                this.setState({
                    pressed: value
                }, def.resolve.bind(def));

                return def;
            }
        }]);

        return Toggle;
    }(_filter2.default);

    exports.default = Toggle;
    module.exports = exports['default'];
});