define('bitbucket/internal/bbui/reviewer-avatar/reviewer-avatar', ['module', 'exports', '@atlassian/aui', 'lodash', 'prop-types', 'react', 'bitbucket/internal/enums', '../aui-react/avatar'], function (module, exports, _aui, _lodash, _propTypes, _react, _enums, _avatar) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _lodash2 = _interopRequireDefault(_lodash);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var propTypes = {
        avatarSize: _propTypes2.default.string,
        reviewer: _propTypes2.default.shape({
            user: _propTypes2.default.object.isRequired,
            status: _propTypes2.default.oneOf(_lodash2.default.values(_enums.ApprovalStatus)).isRequired
        }).isRequired,
        withName: _propTypes2.default.bool,
        tooltip: _propTypes2.default.bool,
        nameOnly: _propTypes2.default.bool
    };

    var visibleBadgeCssClass = {
        APPROVED: 'aui-icon aui-icon-xsmall aui-iconfont-approve approved',
        NEEDS_WORK: 'aui-icon aui-icon-xsmall aui-iconfont-needs-work needs-work'
    };

    var avatarBadges = [{
        className: visibleBadgeCssClass.APPROVED,
        text: _aui.I18n.getText('bitbucket.component.avatar.badge.approved')
    }, {
        className: visibleBadgeCssClass.NEEDS_WORK,
        text: _aui.I18n.getText('bitbucket.component.avatar.badge.needs.work')
    }];

    function reviewerTooltip(reviewer, nameOnly) {
        var name = reviewer.user.displayName || reviewer.user.name;
        var displayText = void 0;

        if (nameOnly || !reviewer.status || reviewer.status === _enums.ApprovalStatus.UNAPPROVED) {
            displayText = name;
        } else if (reviewer.status === _enums.ApprovalStatus.APPROVED) {
            displayText = _aui.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.approved', name);
        } else {
            displayText = _aui.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.needs.work', name);
        }

        return displayText;
    }

    var ReviewerAvatar = function (_Component) {
        _inherits(ReviewerAvatar, _Component);

        function ReviewerAvatar() {
            _classCallCheck(this, ReviewerAvatar);

            return _possibleConstructorReturn(this, (ReviewerAvatar.__proto__ || Object.getPrototypeOf(ReviewerAvatar)).apply(this, arguments));
        }

        _createClass(ReviewerAvatar, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(newProps) {
                return this.props.reviewer.user.name !== newProps.reviewer.user.name || this.props.reviewer.status !== newProps.reviewer.status || this.props.avatarSize !== newProps.avatarSize || Boolean(this.props.nameOnly) !== Boolean(newProps.nameOnly) || Boolean(this.props.tooltip) !== Boolean(newProps.tooltip) || Boolean(this.props.withName) !== Boolean(newProps.withName);
            }
        }, {
            key: 'render',
            value: function render() {
                var props = this.props;

                return _react2.default.createElement(_avatar.UserAvatar, {
                    person: props.reviewer.user,
                    size: props.avatarSize,
                    badges: avatarBadges,
                    tooltipText: reviewerTooltip(props.reviewer, props.nameOnly),
                    visibleBadge: props.reviewer.status ? visibleBadgeCssClass[props.reviewer.status] : '',
                    withName: props.withName,
                    withTooltip: props.tooltip
                });
            }
        }]);

        return ReviewerAvatar;
    }(_react.Component);

    ReviewerAvatar.propTypes = propTypes;
    exports.default = ReviewerAvatar;
    module.exports = exports['default'];
});