define('bitbucket/internal/bbui/scroll-handler/scroll-handler', ['module', 'exports', 'jquery', 'prop-types', 'react'], function (module, exports, _jquery, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var docEl = window.document.documentElement;

    var ScrollHandler = function (_React$Component) {
        _inherits(ScrollHandler, _React$Component);

        function ScrollHandler() {
            _classCallCheck(this, ScrollHandler);

            return _possibleConstructorReturn(this, (ScrollHandler.__proto__ || Object.getPrototypeOf(ScrollHandler)).apply(this, arguments));
        }

        _createClass(ScrollHandler, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var scrollElement = this.props.scrollElement;


                this.updateListeners(null, scrollElement);

                //trigger an initial callback in case the current content is shorter than the window.
                if (this._scrollCallback) {
                    this._scrollCallback(scrollElement);
                }
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(previousProps) {
                var scrollElement = this.props.scrollElement;


                this.updateListeners(previousProps.scrollElement, scrollElement);

                //Trigger a followup callback in case the current content is still shorter than the window after updating.
                if (this._scrollCallback) {
                    this._scrollCallback(scrollElement);
                }
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                this.updateListeners(this.props.scrollElement, null);
            }
        }, {
            key: 'scrollCallback',
            value: function scrollCallback(scrollElement) {
                var _props = this.props,
                    containerElement = _props.containerElement,
                    suspend = _props.suspend,
                    bufferPx = _props.bufferPx,
                    onScrollToBottom = _props.onScrollToBottom;


                if (suspend) {
                    return;
                }

                var $scrollElement = (0, _jquery2.default)(scrollElement);

                if (!this._scrollingWindow && $scrollElement.is(':hidden')) {
                    return;
                }

                var scrollTop = $scrollElement.scrollTop();
                var paneHeight = this._getPaneHeight();
                var contentHeight = this._getContentHeight();
                var scrollBottom = paneHeight + scrollTop;

                // In Chrome (not checked since like v12) on Windows at some font sizes (Ctrl +), the scrollPaneHeight is rounded down, but contentHeight is
                // rounded up (I think). This means there is a 1px difference between them and the event won't fire.
                var chromeWindowsFontChangeBuffer = 1;

                var scrolledToBottom = void 0;

                if (containerElement) {
                    var bottomOffset = containerElement.getBoundingClientRect().bottom;
                    scrolledToBottom = bottomOffset - window.innerHeight < (bufferPx | 0);
                } else {
                    scrolledToBottom = scrollBottom + chromeWindowsFontChangeBuffer >= contentHeight - (bufferPx | 0);
                }

                if (scrolledToBottom) {
                    onScrollToBottom();
                }
            }
        }, {
            key: 'updateListeners',
            value: function updateListeners(previousScrollElement, currentScrollElement) {
                previousScrollElement = (0, _jquery2.default)(previousScrollElement)[0];
                currentScrollElement = (0, _jquery2.default)(currentScrollElement)[0];

                if (previousScrollElement === currentScrollElement) {
                    return;
                }

                if (previousScrollElement) {
                    (0, _jquery2.default)(previousScrollElement).off('scroll', this._scrollCallback);
                    (0, _jquery2.default)(window).off('resize', this._scrollCallback);
                }

                if (currentScrollElement) {
                    this._scrollCallback = this.scrollCallback.bind(this, currentScrollElement);
                    this._scrollingWindow = _jquery2.default.isWindow(currentScrollElement);
                    this._getPaneHeight = this._scrollingWindow ? function () {
                        return docEl.clientHeight;
                    } : function () {
                        return currentScrollElement.clientHeight;
                    };
                    this._getContentHeight = this._scrollingWindow ? function () {
                        return docEl.scrollHeight;
                    } : function () {
                        return currentScrollElement.scrollHeight;
                    };
                    (0, _jquery2.default)(currentScrollElement).on('scroll', this._scrollCallback);
                    (0, _jquery2.default)(window).on('resize', this._scrollCallback);
                }
            }
        }, {
            key: 'render',
            value: function render() {
                return this.props.children;
            }
        }]);

        return ScrollHandler;
    }(_react2.default.Component);

    ScrollHandler.propTypes = {
        bufferPx: _propTypes2.default.number,
        children: _propTypes2.default.element.isRequired,
        containerElement: _propTypes2.default.instanceOf(Element),
        onScrollToBottom: _propTypes2.default.func.isRequired,
        scrollElement: _propTypes2.default.oneOfType([_propTypes2.default.node, _propTypes2.default.oneOf([window])]),
        suspend: _propTypes2.default.bool
    };
    ScrollHandler.defaultProps = {
        scrollElement: window
    };
    exports.default = ScrollHandler;
    module.exports = exports['default'];
});