define('bitbucket/internal/bbui/selectors/user-permissions', ['exports', 'reselect'], function (exports, _reselect) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getHasSourceRepoRead = exports.getHasSourceRepoWrite = exports.getHasRepoWrite = exports.getCanDelete = undefined;


    var getPermissions = function getPermissions(state) {
        return state.userPermissions;
    };

    var getCanDelete = exports.getCanDelete = (0, _reselect.createSelector)([getPermissions], function (permissions) {
        return permissions.canDelete || false;
    });

    var getHasRepoWrite = exports.getHasRepoWrite = (0, _reselect.createSelector)([getPermissions], function (permissions) {
        return permissions.hasRepoWrite || false;
    });

    var getHasSourceRepoWrite = exports.getHasSourceRepoWrite = (0, _reselect.createSelector)([getPermissions], function (permissions) {
        return permissions.hasSourceRepoWrite || false;
    });

    var getHasSourceRepoRead = exports.getHasSourceRepoRead = (0, _reselect.createSelector)([getPermissions], function (permissions) {
        return permissions.hasSourceRepoRead || false;
    });
});