define('bitbucket/internal/enums', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    /**
     * Major entity names. Add to as required
     * @enum {string}
     */
    var Entity = exports.Entity = Object.freeze({
        COMMIT: 'COMMIT',
        PROJECT: 'PROJECT',
        PULL_REQUEST: 'PULL_REQUEST',
        REPOSITORY: 'REPOSITORY',
        USER: 'USER',
        MIRROR: 'MIRROR',
        MIRROR_DETAILED: 'MIRROR_DETAILED'
    });

    /**
     * A user type
     * @enum {string}
     */
    var UserType = exports.UserType = Object.freeze({
        NORMAL: 'NORMAL',
        SERVICE: 'SERVICE'
    });

    /**
     * A project type
     * @enum {string}
     */
    var ProjectType = exports.ProjectType = Object.freeze({
        NORMAL: 'NORMAL',
        PERSONAL: 'PERSONAL'
    });

    /**
     * The SCM type
     * @enum {string}
     */
    var ScmType = exports.ScmType = Object.freeze({
        GIT: 'git',
        HG: 'hg'
    });

    /**
     * The type of a ref
     * @enum {string}
     */
    var RefType = exports.RefType = Object.freeze({
        TAG: 'TAG',
        BRANCH: 'BRANCH'
    });

    /**
     * Pull request participant's role
     * @enum {string}
     */
    var ParticipantRole = exports.ParticipantRole = Object.freeze({
        AUTHOR: 'AUTHOR',
        REVIEWER: 'REVIEWER',
        PARTICIPANT: 'PARTICIPANT'
    });

    /**
     * Pull request Participant's approval state of the pull request
     * @enum {string}
     */
    var ApprovalStatus = exports.ApprovalStatus = Object.freeze({
        APPROVED: 'APPROVED',
        NEEDS_WORK: 'NEEDS_WORK',
        UNAPPROVED: 'UNAPPROVED',
        REVIEWING: 'REVIEWING'
    });

    /**
     * User's actions to add/remove themselves from a PR
     * @enum {string}
     */
    var SelfAction = exports.SelfAction = Object.freeze({
        ADD_SELF: 'ADD_SELF',
        REMOVE_SELF: 'REMOVE_SELF'
    });

    /**
     * Pull request state
     * @enum {string}
     */
    var PullRequestState = exports.PullRequestState = Object.freeze({
        OPEN: 'OPEN',
        MERGED: 'MERGED',
        DECLINED: 'DECLINED'
    });

    var BranchStability = exports.BranchStability = Object.freeze({
        STABLE: 'stable',
        UNSTABLE: 'unstable'
    });

    var MergeOutcome = exports.MergeOutcome = Object.freeze({
        CLEAN: 'CLEAN',
        CONFLICTED: 'CONFLICTED',
        UNKNOWN: 'UNKNOWN'
    });

    var RepositoryState = exports.RepositoryState = Object.freeze({
        AVAILABLE: 'AVAILABLE',
        INITIALISATION_FAILED: 'INITIALISATION_FAILED',
        INITIALISING: 'INITIALISING'
    });

    /**
     * Change types of a file changeset
     *
     * @enum {string}
     */
    var ChangeTypes = exports.ChangeTypes = Object.freeze({
        ADD: 'ADD',
        COPY: 'COPY',
        DELETE: 'DELETE',
        MODIFY: 'MODIFY',
        MOVE: 'MOVE',
        RENAME: 'RENAME',
        UNKNOWN: 'UNKNOWN',
        SOURCE: 'SOURCE'
    });

    /**
     * @type {Readonly<{CONFLICT: string, ADDED: string, MODIFIED: string, CONTEXT: string, REMOVED: string}>}
     * @enum {string}
     */
    var DiffSegmentTypes = exports.DiffSegmentTypes = Object.freeze({
        ADDED: 'ADDED',
        REMOVED: 'REMOVED',
        CONTEXT: 'CONTEXT',
        MODIFIED: 'MODIFIED',
        CONFLICT: 'CONFLICT'
    });

    var DiffFileTypes = exports.DiffFileTypes = Object.freeze({
        FROM: 'FROM',
        TO: 'TO'
    });

    var ConflictSegmentTypes = exports.ConflictSegmentTypes = Object.freeze({
        MARKER: 'MARKER',
        OURS: 'OURS',
        THEIRS: 'THEIRS'
    });

    //TODO: Once we clean up the legacy code, it would be good to remove this in favour of feature/changes/change-scope.js
    var DiffType = exports.DiffType = Object.freeze({
        EFFECTIVE: 'EFFECTIVE',
        RANGE: 'RANGE',
        COMMIT: 'COMMIT'
    });

    var ContentNodeType = exports.ContentNodeType = Object.freeze({
        DIRECTORY: 'DIRECTORY',
        FILE: 'FILE',
        SUBMODULE: 'SUBMODULE'
    });

    var Direction = exports.Direction = Object.freeze({
        UP: 'UP',
        DOWN: 'DOWN'
        // THESE ARE THE ONLY TWO DIRECTIONS. EVERYTHING YOU KNOW IS A LIE
    });

    /**
     * Scope type
     * @enum {string}
     */
    var ScopeType = exports.ScopeType = Object.freeze({
        GLOBAL: 'GLOBAL',
        PROJECT: 'PROJECT',
        REPOSITORY: 'REPOSITORY',
        USER: 'USER'
    });

    var SshKeyType = exports.SshKeyType = Object.freeze({
        DSA: 'DSA',
        RSA: 'RSA'
    });

    // used to filter repositories by type
    var RepositoryType = exports.RepositoryType = Object.freeze({
        ACTIVE: 'ACTIVE',
        ARCHIVED: 'ARCHIVED',
        ALL: 'ALL'
    });

    /**
     * Grantable permissions
     *
     * @readonly
     * @enum string
     */
    var Permission = exports.Permission = Object.freeze({
        REPO_READ: 'REPO_READ',
        REPO_WRITE: 'REPO_WRITE',
        REPO_ADMIN: 'REPO_ADMIN',
        PROJECT_READ: 'PROJECT_READ',
        PROJECT_WRITE: 'PROJECT_WRITE',
        REPO_CREATE: 'REPO_CREATE',
        PROJECT_ADMIN: 'PROJECT_ADMIN',
        PROJECT_CREATE: 'PROJECT_CREATE',
        PROJECT_NO_ACCESS: 'PROJECT_NO_ACCESS',
        ADMIN: 'ADMIN',
        SYS_ADMIN: 'SYS_ADMIN',
        LICENSED_USER: 'LICENSED_USER'
    });

    /*eslint-disable no-magic-numbers*/
    /**
     * AUI/ADG Avatar Sizes
     * We fetch @2x size images for HiDPI displays
     * @readonly
     * @enum number
     */
    var AvatarSize = exports.AvatarSize = {
        XSMALL: 16 * 2,
        SMALL: 24 * 2,
        MEDIUM: 32 * 2,
        LARGE: 48 * 2,
        XLARGE: 64 * 2,
        XXLARGE: 96 * 2,
        XXXLARGE: 128 * 2
    };

    /**
     * AUI/ADG Avatar t-shirt Sizes
     * @readonly
     * @enum string
     */
    var AvatarTShirtSize = exports.AvatarTShirtSize = Object.keys(AvatarSize).reduce(function (obj, key) {
        obj[key] = key.toLowerCase();

        return obj;
    }, {});

    //All requests in the `frontend` plugin should use AvatarSize.DEFAULT when making REST requests
    //This must be defined AFTER `AvatarTShirtSize` to avoid polluting that enum
    AvatarSize.DEFAULT = AvatarSize.SMALL;

    /**
     * Possible pattern types for branches.
     *
     * @enum string
     */
    var BranchPatternType = exports.BranchPatternType = Object.freeze({
        BRANCHING_MODEL_CATEGORY: 'MODEL_CATEGORY',
        BRANCHING_MODEL_BRANCH: 'MODEL_BRANCH',
        BRANCHING_MODEL: 'BRANCHING_MODEL',
        BRANCH_PATTERN: 'PATTERN',
        ALL_BRANCHES: 'ANY_REF',
        BRANCH_NAME: 'BRANCH',
        NONE: 'NONE'
    });

    /**
     * The types of branch models provided by Bitbucket
     *
     * @enum string
     */
    var BranchingModels = exports.BranchingModels = Object.freeze({
        // MODEL_BRANCH matchers require lowercase labels
        DEVELOPMENT: 'development',
        PRODUCTION: 'production',
        // MODEL_CATEGORY matchers require uppercase labels
        BUGFIX: 'BUGFIX',
        FEATURE: 'FEATURE',
        HOTFIX: 'HOTFIX',
        RELEASE: 'RELEASE'
    });

    /**
     * Types of project restrictions
     * Any updates in this enum should also be updated in enforce-project-settings.soy
     * @enum string
     */
    var ProjectRestrictionOptions = exports.ProjectRestrictionOptions = Object.freeze({
        LOCKED: 'LOCKED',
        UNLOCKED: 'UNLOCKED'
    });

    var AnimationDuration = exports.AnimationDuration = Object.freeze({
        SHORT: 1000,
        MEDIUM: 2000,
        LONG: 3000
    });

    /**
     * States when creating mirror troubleshooting zip
     * @enum String
     */
    var MirrorTroubleshootingZipStatus = exports.MirrorTroubleshootingZipStatus = Object.freeze({
        INITIAL: 'INITIAL',
        IN_PROGRESS: 'IN_PROGRESS',
        COMPLETE_WITH_WARNING: 'COMPLETE_WITH_WARNING',
        SUCCESSFUL: 'SUCCESSFUL',
        FAILED: 'FAILED'
    });
});