define('bitbucket/internal/feature/admin/storage/store-item', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/bbui/tipsy/tipsy', 'bitbucket/internal/util/text', 'bitbucket/internal/widget/resource-utilization-graph/resource-utilization-graph'], function (module, exports, _aui, _propTypes, _react, _tipsy, _text, _resourceUtilizationGraph) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _tipsy2 = _interopRequireDefault(_tipsy);

    var textUtil = _interopRequireWildcard(_text);

    var _resourceUtilizationGraph2 = _interopRequireDefault(_resourceUtilizationGraph);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var UnavailableItem = function UnavailableItem(_ref) {
        var path = _ref.path;

        return _react2.default.createElement(
            'div',
            { className: 'store-item' },
            _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h5',
                    null,
                    path
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'description' },
                    _react2.default.createElement('span', { className: 'aui-icon aui-icon-small aui-iconfont-error' }),
                    _aui.I18n.getText('bitbucket.web.admin.storage.unavailable.description'),
                    ' ',
                    _react2.default.createElement(
                        'a',
                        { href: bitbucket_help_url('bitbucket.help.storage'), target: '_blank' },
                        _aui.I18n.getText('bitbucket.web.admin.storage.learn.more')
                    )
                )
            ),
            _react2.default.createElement(
                'span',
                { className: 'aui-lozenge aui-lozenge-error' },
                _aui.I18n.getText('bitbucket.web.admin.storage.unavailable')
            )
        );
    };

    UnavailableItem.propTypes = {
        path: _propTypes2.default.string.isRequired
    };

    var percentage = function percentage(total, partial) {
        return Math.round(partial * 100 / total);
    };

    var StoreItem = function StoreItem(_ref2) {
        var store = _ref2.store;
        var totalSpace = store.totalSpace,
            usedSpace = store.usedSpace,
            usableSpace = store.usableSpace,
            path = store.path,
            description = store.description;

        var unavailable = totalSpace === -1;

        if (unavailable) {
            return _react2.default.createElement(UnavailableItem, { path: path });
        }

        var totalSpaceFormatted = textUtil.formatSizeInBytes(totalSpace);
        var totalSpaceDescriptor = textUtil.sizeInBytesDescriptor(totalSpace);
        var usedSpaceNoUnit = textUtil.sizeInBytesDescriptor(usedSpace, totalSpaceDescriptor.unit).value;
        var usableSpaceFormatted = textUtil.formatSizeInBytes(usableSpace);
        var usedPercentage = percentage(totalSpace, usedSpace);

        return _react2.default.createElement(
            'div',
            { className: 'store-item' },
            _react2.default.createElement(
                'div',
                null,
                _react2.default.createElement(
                    'h5',
                    null,
                    path
                ),
                _react2.default.createElement(
                    'p',
                    { className: 'description' },
                    description
                )
            ),
            _react2.default.createElement(
                _tipsy2.default,
                {
                    title: _aui.I18n.getText('bitbucket.web.admin.storage.tooltip.description', usedPercentage, usableSpaceFormatted),
                    gravity: 'n'
                },
                _react2.default.createElement(
                    'p',
                    { className: 'data-value' },
                    usedSpaceNoUnit + ' / ' + totalSpaceFormatted
                ),
                _react2.default.createElement(_resourceUtilizationGraph2.default, { usedPercentage: usedPercentage })
            )
        );
    };

    StoreItem.propTypes = {
        store: _propTypes2.default.object.isRequired
    };

    exports.default = StoreItem;
    module.exports = exports['default'];
});