define('bitbucket/internal/feature/alerts/alerts-trigger', ['module', 'exports', '@atlassian/aui', 'classnames', 'lodash', './constants', './selectors'], function (module, exports, _aui, _classnames, _lodash, _constants, _selectors) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _classnames2 = _interopRequireDefault(_classnames);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var getMostSevere = function getMostSevere(alerts) {
        return (0, _lodash.get)(alerts, '0.type', _constants.AlertType.INFO);
    };

    var Trigger = function () {
        function Trigger($trigger, store) {
            _classCallCheck(this, Trigger);

            this.$el = $trigger;
            this.stateStore = store;
            this.stateStore.subscribe(this.maybeUpdate.bind(this));
            this.render(this.getAlerts());
        }

        _createClass(Trigger, [{
            key: 'getAlerts',
            value: function getAlerts() {
                return (0, _selectors.alertsBySeverity)(this.stateStore.getState());
            }
        }, {
            key: 'maybeUpdate',
            value: function maybeUpdate() {
                var alerts = this.getAlerts();

                if (this.alertCount !== alerts.length || this.mostSevere !== getMostSevere(alerts)) {
                    this.render(alerts);
                }
            }
        }, {
            key: 'render',
            value: function render(alerts) {
                this.alertCount = alerts.length;
                this.mostSevere = getMostSevere(alerts);
                var title = AJS.I18n.getText('bitbucket.web.alerts.title');

                if (!alerts || alerts.length === 0) {
                    this.$el.attr('class', (0, _classnames2.default)('alerts-menu', {
                        hidden: !(0, _selectors.dialogOpen)(this.stateStore.getState())
                    }));

                    return this.$el.html(bitbucket.internal.feature.alerts.alerts.emptyTrigger({
                        title: title
                    }));
                }

                this.$el.attr('class', (0, _classnames2.default)('alerts-menu', this.mostSevere));
                this.$el.html(bitbucket.internal.feature.alerts.alerts.trigger({
                    count: this.alertCount,
                    iconClass: _constants.AlertIcon[this.mostSevere],
                    title: title
                }));
            }
        }]);

        return Trigger;
    }();

    exports.default = Trigger;
    module.exports = exports['default'];
});