define('bitbucket/internal/feature/alerts/constants', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _AlertIcon;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    /**
     * @enum AlertType
     * @type {Object<string>}
     */
    var AlertType = exports.AlertType = {
        ERROR: 'error',
        WARNING: 'warning',
        INFO: 'info',
        SUCCESS: 'success'
    };

    /**
     * @enum AlertIcon
     * @type {Object<string>}
     */
    var AlertIcon = exports.AlertIcon = (_AlertIcon = {}, _defineProperty(_AlertIcon, AlertType.ERROR, 'aui-iconfont-error'), _defineProperty(_AlertIcon, AlertType.WARNING, 'aui-iconfont-warning'), _defineProperty(_AlertIcon, AlertType.INFO, 'aui-iconfont-info-filled'), _defineProperty(_AlertIcon, AlertType.SUCCESS, 'aui-iconfont-check'), _AlertIcon);

    // The array order also defines the sort order in the UI
    var TYPES = exports.TYPES = [AlertType.ERROR, AlertType.WARNING, AlertType.INFO, AlertType.SUCCESS];
});