define('bitbucket/internal/feature/commit-graph/commit-graph', ['exports', 'classnames', 'lodash', 'react', './graph-builder'], function (exports, _classnames, _lodash, _react, _graphBuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Node = exports.Slice = exports.Chunk = exports.Graph = exports.CommitGraph = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var line = function line(x1, y1, x2, y2) {
        return 'M' + x1 + ',' + y1 + ' L' + x2 + ',' + y2;
    };

    var curve = function curve(x1, y1, x2, y2) {
        var midY = Math.round((y2 - y1) / 2);

        var control1Y = y1 + midY;
        var control2Y = y2 - midY;

        return 'M' + x1 + ',' + y1 + ' C' + x1 + ',' + control1Y + ' ' + x2 + ',' + control2Y + ' ' + x2 + ',' + y2;
    };

    //Will return `0` for an empty graph, `1` for a graph of 1 node, and `n` for a graph of n columns
    var getMaxColumns = function getMaxColumns(graph) {
        return graph.length && (0, _lodash.max)([1].concat(graph.map(function (node) {
            return node.segments.length;
        })));
    };

    var CommitGraph = exports.CommitGraph = function (_Component) {
        _inherits(CommitGraph, _Component);

        function CommitGraph() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, CommitGraph);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = CommitGraph.__proto__ || Object.getPrototypeOf(CommitGraph)).call.apply(_ref, [this].concat(args))), _this), _this.buildGraph = (0, _lodash.memoize)(_graphBuilder.buildGraph), _this.getMaxColumns = (0, _lodash.memoize)(getMaxColumns), _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(CommitGraph, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(_ref2) {
                var collapsed = _ref2.collapsed;

                //Don't update if the graph is collapsed, unless it is transitioning to collapsed.
                return this.props.collapsed !== collapsed || !collapsed;
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    colWidth = _props.colWidth,
                    commits = _props.commits,
                    collapsed = _props.collapsed,
                    focusedId = _props.focusedCommitId,
                    offsetX = _props.offsetX,
                    offsetY = _props.offsetY,
                    onNodeClick = _props.onNodeClick,
                    sliceHeight = _props.sliceHeight;


                if (!commits.length) {
                    return null;
                }

                if (!this.chunkSize) {
                    //Set the chunk size based on the first page of commits
                    this.chunkSize = commits.length;
                }

                var graph = this.buildGraph(commits);
                var width = collapsed ? 0 : offsetX + this.getMaxColumns(graph) * colWidth;

                return _react2.default.createElement(Graph, {
                    chunkSize: this.chunkSize,
                    colWidth: colWidth,
                    focusedId: focusedId,
                    graph: graph,
                    offsetX: offsetX,
                    offsetY: offsetY,
                    onNodeClick: onNodeClick,
                    sliceHeight: sliceHeight,
                    width: width
                });
            }
        }]);

        return CommitGraph;
    }(_react.Component);

    CommitGraph.defaultProps = {
        colWidth: 8,
        sliceHeight: 40,
        offsetX: 8, //Same as colWidth
        offsetY: 20 //Half sliceHeight
    };
    var Graph = exports.Graph = (0, _react.memo)(function (_ref3) {
        var chunkSize = _ref3.chunkSize,
            className = _ref3.className,
            colWidth = _ref3.colWidth,
            focusedId = _ref3.focusedId,
            graph = _ref3.graph,
            offsetX = _ref3.offsetX,
            offsetY = _ref3.offsetY,
            onNodeClick = _ref3.onNodeClick,
            sliceHeight = _ref3.sliceHeight,
            width = _ref3.width;

        return _react2.default.createElement(
            'svg',
            { className: 'commit-graph', width: width },
            (0, _lodash.chunk)(graph, chunkSize).map(function (chunk, index) {
                return _react2.default.createElement(Chunk, {
                    chunk: chunk,
                    colWidth: colWidth,
                    focusedId: focusedId,
                    key: 'chunk-' + chunk[0].id,
                    left: offsetX,
                    onNodeClick: onNodeClick,
                    sliceHeight: sliceHeight,
                    top: offsetY + index * chunkSize * sliceHeight
                });
            })
        );
    });

    /**
     * Group the graph into "chunks" to isolate style recalculations when new nodes are added.
     */

    var Chunk = exports.Chunk = function (_Component2) {
        _inherits(Chunk, _Component2);

        function Chunk() {
            _classCallCheck(this, Chunk);

            return _possibleConstructorReturn(this, (Chunk.__proto__ || Object.getPrototypeOf(Chunk)).apply(this, arguments));
        }

        _createClass(Chunk, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(_ref4) {
                var _this3 = this;

                var chunk = _ref4.chunk,
                    focusedId = _ref4.focusedId;

                return chunk[0].id !== this.props.chunk[0].id || chunk.length !== this.props.chunk.length ||
                //Check if the focused node has changed, and if it has, is it a change that this chunk cares about
                //(either the old or new focused node is contained in this chunk), otherwise don't update.
                //This may look expensive but it's not. It takes a fraction of a millisecond for 50 item chunks.
                //Much faster than doing the render and compare, even if the child slices don't update.
                focusedId !== this.props.focusedId && chunk.some(function (_ref5) {
                    var id = _ref5.id;
                    return id === _this3.props.focusedId || id === focusedId;
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    chunk = _props2.chunk,
                    focusedId = _props2.focusedId,
                    left = _props2.left,
                    top = _props2.top,
                    colWidth = _props2.colWidth,
                    onNodeClick = _props2.onNodeClick,
                    sliceHeight = _props2.sliceHeight;


                return _react2.default.createElement(
                    'g',
                    { transform: 'translate(' + left + ', ' + top + ')' },
                    chunk.map(function (slice, index) {
                        return _react2.default.createElement(Slice, {
                            colWidth: colWidth,
                            focused: slice.id === focusedId,
                            key: 'slice-' + slice.id,
                            onNodeClick: onNodeClick,
                            slice: slice,
                            sliceHeight: sliceHeight,
                            top: index * sliceHeight
                        });
                    })
                );
            }
        }]);

        return Chunk;
    }(_react.Component);

    var Slice = exports.Slice = function (_Component3) {
        _inherits(Slice, _Component3);

        function Slice() {
            _classCallCheck(this, Slice);

            return _possibleConstructorReturn(this, (Slice.__proto__ || Object.getPrototypeOf(Slice)).apply(this, arguments));
        }

        _createClass(Slice, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(_ref6) {
                var focused = _ref6.focused;

                return focused !== this.props.focused;
            }
        }, {
            key: 'render',
            value: function render() {
                var _props3 = this.props,
                    slice = _props3.slice,
                    colWidth = _props3.colWidth,
                    sliceHeight = _props3.sliceHeight,
                    focused = _props3.focused,
                    onNodeClick = _props3.onNodeClick,
                    top = _props3.top;
                var id = slice.id,
                    column = slice.column,
                    color = slice.color,
                    segments = slice.segments;

                var nodeX = column * colWidth;
                var nodeY = top;

                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    segments.map(function (_ref7) {
                        var startColumn = _ref7.startColumn,
                            endColumn = _ref7.endColumn,
                            edgeColor = _ref7.color;

                        var fromX = startColumn * colWidth;
                        var fromY = nodeY;
                        var toX = endColumn * colWidth;
                        var toY = fromY + sliceHeight;
                        var buildPath = startColumn === endColumn ? line : curve;

                        return _react2.default.createElement('path', {
                            key: 'path-' + id + '-' + startColumn + '-' + endColumn,
                            d: buildPath(fromX, fromY, toX, toY),
                            className: 'color-' + edgeColor % 6
                        });
                    }),
                    _react2.default.createElement(Node, {
                        id: id,
                        x: nodeX,
                        y: nodeY,
                        color: color,
                        focused: focused,
                        onClick: onNodeClick
                    })
                );
            }
        }]);

        return Slice;
    }(_react.Component);

    var Node = exports.Node = function (_PureComponent) {
        _inherits(Node, _PureComponent);

        function Node() {
            var _ref8;

            var _temp2, _this5, _ret2;

            _classCallCheck(this, Node);

            for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                args[_key2] = arguments[_key2];
            }

            return _ret2 = (_temp2 = (_this5 = _possibleConstructorReturn(this, (_ref8 = Node.__proto__ || Object.getPrototypeOf(Node)).call.apply(_ref8, [this].concat(args))), _this5), _this5.state = {
                hover: false
            }, _this5.onClick = function () {
                var _this5$props = _this5.props,
                    onClick = _this5$props.onClick,
                    id = _this5$props.id;


                if ((0, _lodash.isFunction)(onClick)) {
                    onClick(id);
                }
            }, _this5.hover = function () {
                _this5.setState({ hover: true });
            }, _this5.unhover = function () {
                _this5.setState({ hover: false });
            }, _temp2), _possibleConstructorReturn(_this5, _ret2);
        }

        _createClass(Node, [{
            key: 'render',
            value: function render() {
                var _props4 = this.props,
                    color = _props4.color,
                    focused = _props4.focused,
                    x = _props4.x,
                    y = _props4.y;
                var hover = this.state.hover;

                /* eslint-disable jsx-a11y/mouse-events-have-key-events */

                return _react2.default.createElement('circle', {
                    cx: x,
                    cy: y,
                    r: focused || hover ? 5 : 3 //💩 This can't be controlled by CSS in all browsers
                    , className: (0, _classnames2.default)('color-' + color % 6, { focused: focused }),
                    onClick: this.onClick,
                    onMouseOver: this.hover,
                    onMouseOut: this.unhover
                });
                /* eslint-enable jsx-a11y/mouse-events-have-key-events */
            }
        }]);

        return Node;
    }(_react.PureComponent);
});